package cz.cuni.amis.pogamut.edu.drools;

import java.util.List;
import java.util.Map;
import java.util.LinkedList;
import java.util.HashMap;

import org.drools.WorkingMemory;

/**
 * FactCollector registers facts that should be in the working memory only for
 * single fireAllRules() call. The Scenario loop calls the clear method where
 * the FactCollector retracts these facts from the working memory.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class FactCollector {
	protected static Map<WorkingMemory, List<IFact>> factLists = new HashMap<WorkingMemory, List<IFact>>();

	/**
	 * Registers a new fact in the working memory
	 * 
	 * @param workingMemory
	 * @param fact
	 */
	public static void add(WorkingMemory workingMemory, IFact fact) {
		List<IFact> facts = factLists.get(workingMemory);
		if (facts == null) {
			facts = new LinkedList<IFact>();
			factLists.put(workingMemory, facts);
		}
		facts.add(fact);
	}

	/**
	 * Retracts all fact from the specified working memory.
	 * 
	 * @param workingMemory
	 */
	public static void clear(WorkingMemory workingMemory) {
		List<IFact> facts = factLists.get(workingMemory);
		if (facts != null) {
			for (IFact fact : facts) {
				fact.retractFrom(workingMemory);
			}
			facts.clear();
		}
	}
}
