package cz.cuni.amis.pogamut.edu.controlserver;

import cz.cuni.amis.pogamut.edu.agent.Player;
import cz.cuni.amis.pogamut.edu.drools.SimpleFact;

/**
 * The key event that has occurred in the game to some player. These events are
 * in working memory for only one rule loop cycle, the FactCollector removes
 * them after that (if they aren't removed manually in the rules).
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class KeyEvent extends SimpleFact {
	public enum Event {
		PRESS, RELEASE, HOLD
	}

	protected Event event;
	protected String key;
	protected Player player;

	public Player getPlayer() {
		return player;
	}

	public KeyEvent(Event event, String key, Player player) {
		this.event = event;
		this.key = key;
		this.player = player;
	}

	public Event getEvent() {
		return event;
	}

	public String getKey() {
		return key;
	}
}
