package cz.cuni.amis.pogamut.edu.controlserver;

import cz.cuni.amis.pogamut.base.server.commands.IBotControl;
import cz.cuni.amis.pogamut.base.server.commands.IPlayerCommunication;
import cz.cuni.amis.pogamut.base.server.commands.IPlayerControl;
import cz.cuni.amis.pogamut.edu.Scenario;

/**
 * Game-independent interface for the control server connected to Pogamut.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public interface IControlServer {

	/**
	 * Used to control (displace etc.) bots.
	 * 
	 * @return
	 */
	public IBotControl getBotControl();

	/**
	 * Used to control (move, turn, displace...) players.
	 * 
	 * @return
	 */
	public IPlayerControl getPlayerControl();

	/**
	 * Used to display messages, interaction with dialogs and playing sounds.
	 * 
	 * @return
	 */
	public IPlayerCommunication getPlayerCommunication();

	/**
	 * Sets the scenario this server is associated to.
	 * 
	 * @param scenario
	 */
	public void setScenario(Scenario scenario);
}
