package cz.cuni.amis.pogamut.edu.agent;

import cz.cuni.amis.pogamut.base.agent.IAgent;

/**
 * The agent that is driven by AI, not by a user.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class Bot extends Agent {
	/**
	 * The reference to Pogamut bot.
	 */
	protected IAgent assocBot;

	public Bot(IAgent bot) {
		this(bot, bot.getName());
	}

	public Bot(IAgent bot, String name) {
		super(name);
		this.assocBot = bot;
	}

	public IAgent getAssocBot() {
		return assocBot;
	}

	@Override
	public String getInGameName() {
		return getName();
	}

}
