package cz.cuni.amis.pogamut.edu.agent;

import java.util.LinkedList;
import java.util.List;

import cz.cuni.amis.pogamut.base3d.worldview.objects.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.objects.IRotable;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Rotation;
import cz.cuni.amis.pogamut.edu.drools.SimpleFact;
import cz.cuni.amis.pogamut.edu.map.areas.IArea;

/**
 * The common ancestor of Player and Bot (and theoretically any being in the
 * virtual reality).
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public abstract class Agent extends SimpleFact implements ILocated, IRotable {

	protected Location location;
	protected Rotation rotation;

	/**
	 * Areas where the agent is currently located - it is not used directly, but
	 * we have to know from which areas we should remove the agent
	 */
	protected List<IArea> areas = new LinkedList<IArea>();

	public Agent() {

	}

	public Agent(String name) {
		super(name);
	}

	/**
	 * The game as used in the game. It can differ from the name that is used in
	 * the rules.
	 * 
	 * @return
	 */
	public abstract String getInGameName();

	public Location getLocation() {
		return location;
	}

	public Rotation getRotation() {
		return rotation;
	}

	public void setLocation(Location location) {
		this.location = location;
		update();
	}

	public void setRotation(Rotation rotation) {
		this.rotation = rotation;
		update();
	}

	/**
	 * Areas that the agent currently is in. It is used for removal from them in
	 * the next position update.
	 * 
	 * @return
	 */
	public List<IArea> getAreas() {
		return areas;
	}

	/**
	 * See getAreas().
	 * 
	 * @param areas
	 */
	public void setAreas(List<IArea> areas) {
		this.areas = areas;
	}

}
