package cz.cuni.amis.pogamut.edu;

import java.util.Vector;

import cz.cuni.amis.pogamut.edu.drools.SimpleFact;

/**
 * Act is some part of the story. There are two reasons to write the structure
 * of the scenario down. The first is to help you plan that out. Sketching of
 * the scenario before the implementation eases thinking the scenario over. The
 * second reason is to simplify referring to parts of the story. One act can
 * contain multiple other acts - e.g. scenario workday should include acts
 * morning, work-shift and evening, where morning includes waking up,
 * breakfast etc. The workday is in one of these states in each moment. But
 * when you are breakfasting it also means that it is morning, too. The
 * questions whether the scenario is performing the act that is superior to the
 * performed act are answered positively.
 * Nevertheless, such straight division is frequently not enough. When you see a
 * car rushing at you, you'll jump out off the road regardless of whether it's
 * morning or evening and then continue with previous tasks. That's why the
 * scenario can be in multiple different acts but it has to be from different
 * act tree (the two acts have no common superior act).
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class Act extends SimpleFact {

	protected Vector<Act> children = new Vector<Act>();
	protected boolean isActive = false;
	protected long mark = 0;

	protected Act parent;

	public Act(String name, Act parent, Scenario scenario) {
		super(name);
		this.parent = parent;
		insertTo(scenario.getWorkingMemory());
	}

	public void add(Act act) {
		children.add(act);
	}

	public long getMark() {
		return mark;
	}

	public Act getParent() {
		return parent;
	}

	public boolean isActive() {
		return isActive;
	}

	public void setActive(boolean isActive, long mark) {
		this.mark = mark;
		if (this.isActive != isActive) {
			this.isActive = isActive;
			update();
		}
	}
}
