package cz.cuni.amis.pogamut.edu.map.editor.wizard;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

import cz.cuni.amis.pogamut.edu.map.editor.utils.AllowOnlyNumbers;

public class SelectInitialContentPage extends WizardPage {

	protected Text scale;
	protected Text originX;
	protected Text originY;
	protected Text src;
	protected Text unrealId;
	
	protected ModifyListener updateFinish = new ModifyListener() {

		@Override
		public void modifyText(ModifyEvent e) {
			SelectInitialContentPage.this.getWizard().getContainer().updateButtons();
		}
		
	};

	protected SelectInitialContentPage() {
		super("Select initial content");
		setTitle("Select initial content");
		setDescription("Selects initial content as map plan, scaling etc.");
	}

	@Override
	public void createControl(Composite parent) {
		final Composite composite = new Composite(parent, SWT.NONE);
		GridLayout gl = new GridLayout(3, false);
		composite.setLayout(gl);
		new Label(composite, SWT.NONE).setText("Plan image:");
		src = new Text(composite, SWT.BORDER);
		Button browse = new Button(composite, SWT.PUSH);
		browse.setText("Browse...");
		browse.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				FileDialog dialog = new FileDialog(composite.getShell());
				dialog.setFilterNames(new String[] { "Image Files",
						"All Files (*.*)" });
				dialog.setFilterExtensions(new String[] {
						"*.gif;*.png;*.bmp;*.jpg;*.jpeg;*.tiff", "*.*" });
				src.setText(dialog.open());
			}

		});
		src.addModifyListener(updateFinish);
		Listener allowOnlyNumbers = new AllowOnlyNumbers();
		GridData gd = new GridData();
		gd.horizontalSpan = 2;
		new Label(composite, SWT.NONE).setText("UnrealID:");
		unrealId = new Text(composite, SWT.BORDER);
		unrealId.addModifyListener(updateFinish);
		unrealId.setLayoutData(gd);
		new Label(composite, SWT.NONE).setText("Scale:");
		scale = new Text(composite, SWT.BORDER);
		scale.addListener(SWT.Verify, allowOnlyNumbers);
		scale.addModifyListener(updateFinish);
		scale.setLayoutData(gd);
		new Label(composite, SWT.NONE).setText("Origin x:");
		originX = new Text(composite, SWT.BORDER);
		originX.addListener(SWT.Verify, allowOnlyNumbers);
		originX.setLayoutData(gd);
		originX.addModifyListener(updateFinish);
		new Label(composite, SWT.NONE).setText("Origin y:");
		originY = new Text(composite, SWT.BORDER);
		originY.addListener(SWT.Verify, allowOnlyNumbers);
		originY.setLayoutData(gd);
		originY.addModifyListener(updateFinish);
		setControl(composite);
	}

	public String generateContent() {
		StringBuilder content = new StringBuilder();
		content.append("<?xml version=\"1.0\" ?>\n\n");
		content.append("<map>\n");
		content.append("    <plan src=\"");
		content.append(src.getText());
		content.append("\" unrealId=\"");
		content.append(unrealId.getText());
		content.append("\" scale=\"");
		content.append(scale.getText());
		content.append("\" originX=\"");
		content.append(originX.getText());
		content.append("\" originY=\"");
		content.append(originY.getText());
		content.append("\"></plan>\n");
		content.append("</map>\n");
		return content.toString();
	}

	@Override
	public boolean isPageComplete() {
		if (src != null && !src.getText().isEmpty()&& unrealId != null
				&& !unrealId.getText().isEmpty() && scale != null
				&& !scale.getText().isEmpty() && originX != null
				&& !originX.getText().isEmpty() && originY != null
				&& !originY.getText().isEmpty()) {
			return super.isPageComplete();
		}
		return false;
	}
}
