package cz.cuni.amis.pogamut.edu.map.editor.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class NewEduMapFileWizard extends Wizard implements INewWizard {

	private IStructuredSelection selection;
	private NewEduMapFilePage newFilePage;
	private SelectInitialContentPage selectContentPage;
	private IWorkbench workbench;

	public NewEduMapFileWizard() {
		setWindowTitle("New EduMap File");
	}

	@Override
	public void addPages() {
		newFilePage = new NewEduMapFilePage(selection);
		addPage(newFilePage);
		selectContentPage = new SelectInitialContentPage();
		addPage(selectContentPage);
	}

	@Override
	public boolean performFinish() {
		newFilePage.setContent(selectContentPage.generateContent());
		IFile file = newFilePage.createNewFile();
		if (file != null) {
			IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
			IWorkbenchPage page = window.getActivePage();
			try {
				IDE.openEditor(page, file, "EduMapEditor.visualEditor");
			} catch (PartInitException e) {
				e.printStackTrace();
			}
			return true;
		} else {
			return false;
		}
	}

	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.selection = selection;
		this.workbench = workbench;
	}
}
