package cz.cuni.amis.pogamut.edu.map.editor.wizard;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class NewEduMapFilePage extends WizardNewFileCreationPage {

	protected String content;
	
	public NewEduMapFilePage(IStructuredSelection selection) {
		super("New EduMap file", selection);
		setTitle("New EduMap file");
		setDescription("Creates a new map file for Educational Scenarios.");
		setFileExtension("xml");
	}

	@Override
	protected InputStream getInitialContents() {
		return new ByteArrayInputStream(content.getBytes());
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}
}
