package cz.cuni.amis.pogamut.edu.map.editor.visual.tools;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

import cz.cuni.amis.pogamut.edu.map.editor.Activator;
import cz.cuni.amis.pogamut.edu.map.editor.utils.ICoordsTransformer;
import cz.cuni.amis.pogamut.edu.map.editor.visual.ToolKit;

public abstract class Tool implements SelectionListener {

	protected ToolItem item;
	protected boolean needsFullUpdate = false;
	protected boolean needsUpdate = false;
	protected ToolKit toolKit;

	public Tool(ToolKit toolKit, int style, String image, String toolTip) {
		this.toolKit = toolKit; 
		item = new ToolItem((ToolBar) toolKit.getComposite(), style);
		item.setImage(Activator.getDefault().getImageRegistry().get(image));
		item.setToolTipText(toolTip);
		item.addSelectionListener(this);
	}

	public void draw(GC gc, ICoordsTransformer coordsTransformer) {
	}

	public void drawDirect(GC gc, ICoordsTransformer coordsTransformer) {
	}
	
	protected void error(String message) {
		MessageBox mb = new MessageBox(toolKit.getEditor().getShell(), SWT.OK);
		mb.setText("Error");
		mb.setMessage(message);
		mb.open();
	}

	public boolean getNeedsFullUpdate() {
		boolean temp = needsFullUpdate;
		needsFullUpdate = false;
		return temp;
	}

	public boolean getNeedsUpdate() {
		boolean temp = needsUpdate;
		needsUpdate = false;
		return temp;
	}

	public ToolItem getToolItem() {
		return item;
	}

	public void setNeedsUpdate(boolean update, boolean full) {
		needsUpdate = update;
		needsFullUpdate = update & full;
	}

	public void widgetDefaultSelected(SelectionEvent e) {
		toolKit.setActiveTool(this);
	}

	public void widgetSelected(SelectionEvent e) {
		toolKit.setActiveTool(this);
	}
}
