package cz.cuni.amis.pogamut.edu.map.editor.visual.tools;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;

import cz.cuni.amis.pogamut.edu.map.areas.IArea;
import cz.cuni.amis.pogamut.edu.map.editor.Activator;
import cz.cuni.amis.pogamut.edu.map.editor.visual.ToolKit;
import cz.cuni.amis.pogamut.edu.map.marks.IMark;

public class SelectTool extends Tool implements MouseListener, KeyListener {

	static {
		Activator.getDefault().getImageRegistry().put("pointer",
			Activator.getImageDescriptor("icons/pointer.gif"));
	}

	public SelectTool(ToolKit toolKit) {
		super(toolKit, SWT.RADIO, "pointer", "Select tool");
	}

	@Override
	public void widgetSelected(SelectionEvent e) {
		super.widgetSelected(e);
		setNeedsUpdate(true, true);
	}

	@Override
	public void mouseDoubleClick(MouseEvent e) {
	}

	@Override
	public void mouseDown(MouseEvent e) {
		setNeedsUpdate(true, true);
	}

	@Override
	public void mouseUp(MouseEvent e) {
	}

	@Override
	public void keyPressed(KeyEvent e) {
		if (e.keyCode == SWT.DEL || e.keyCode == SWT.BS) {
			Object selected = toolKit.getEditor().getSelected();
			if (selected == null) {
				return;
			} else if (selected instanceof IArea) {
				toolKit.getEditor().removeArea((IArea) selected);
			} else if (selected instanceof IMark) {
				toolKit.getEditor().removeMark((IMark) selected);
			}
			toolKit.getEditor().setSelected(null);
			setNeedsUpdate(true, true);
		} else if (e.keyCode == SWT.ESC) {
			toolKit.getEditor().setSelected(null);
			setNeedsUpdate(true, true);
		}
	}

	@Override
	public void keyReleased(KeyEvent e) {
		// TODO Auto-generated method stub

	}
}
