package cz.cuni.amis.pogamut.edu.map.editor.visual.tools;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;

import cz.cuni.amis.pogamut.edu.map.areas.IArea;
import cz.cuni.amis.pogamut.edu.map.areas.IComplexArea;
import cz.cuni.amis.pogamut.edu.map.editor.Activator;
import cz.cuni.amis.pogamut.edu.map.editor.visual.ToolKit;

public class RemoveFromLockedTool extends Tool {
	static {
		Activator.getDefault().getImageRegistry().put("removefromlocked",
			Activator.getImageDescriptor("icons/removefromlocked.gif"));
	}

	public RemoveFromLockedTool(ToolKit toolKit) {
		super(toolKit, SWT.PUSH, "removefromlocked", "Remove from locked area");
	}

	@Override
	public void widgetSelected(SelectionEvent e) {
		Object selected = toolKit.getEditor().getSelected();
		if (!(selected instanceof IArea)) {
			error("Selected object is not an area!");
			return;
		}
		IArea removed = (IArea)selected;
		IArea locked = toolKit.getEditor().getLocked();
		if (locked == null) {
			error("Nothing is locked, cannot proceed.");
			return;
		}
		if (locked instanceof IComplexArea) {
			if (!((IComplexArea) locked).containsExactly(removed)) {
				error("Selected area is not a part of the locked area!");
				return;
			}
			removed.getSuperior().remove(removed);
			removed.setSuperior(toolKit.getEditor().getMapRootArea());
			removed.getSuperior().add(removed);
		} else {
			error("Cannot remove from locked area - the locked area is only a simple shape.");
			return;
		}
		toolKit.getEditor().getWorkField().update(true);
	}
}
