package cz.cuni.amis.pogamut.edu.map.editor.visual.tools;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.edu.map.areas.IArea;
import cz.cuni.amis.pogamut.edu.map.areas.PolygonArea;
import cz.cuni.amis.pogamut.edu.map.editor.Activator;
import cz.cuni.amis.pogamut.edu.map.editor.Constants;
import cz.cuni.amis.pogamut.edu.map.editor.utils.ICoordsTransformer;
import cz.cuni.amis.pogamut.edu.map.editor.visual.ToolKit;

public class RectTool extends AbstractPolyTool implements MouseListener, MouseMoveListener,
		KeyListener {

	static {
		Activator.getDefault().getImageRegistry().put("recttool",
			Activator.getImageDescriptor("icons/recttool.gif"));
	}

	protected PolygonArea active;
	protected Location first, second;

	public RectTool(ToolKit toolKit) {
		super(toolKit, SWT.RADIO, "recttool", "Rectangle tool");
	}

	@Override
	public void drawDirect(GC gc, ICoordsTransformer coordsTransformer) {
		if (first != null && second != null) {
			Point p1 = coordsTransformer.location2client(first);
			Point p2 = coordsTransformer.location2client(second);
			gc.setForeground(Constants.BLACK);
			gc.drawRectangle(p1.x, p1.y, p2.x - p1.x, p2.y - p1.y);
			drawJoint(gc, p1.x, p1.y);
			drawJoint(gc, p1.x, p2.y);
			drawJoint(gc, p2.x, p1.y);
			drawJoint(gc, p2.x, p2.y);
		}
	}

	private void drawJoint(GC gc, int x, int y) {
		gc.fillRectangle(x - 3, y - 3, 6, 6);
		gc.drawRectangle(x - 3, y - 3, 6, 6);
	}

	@Override
	public void keyPressed(KeyEvent e) {
		if (e.keyCode == SWT.DEL || e.keyCode == SWT.BS) {
			Object selected = toolKit.getEditor().getSelected();
			if (selected != null && selected instanceof IArea) {
				toolKit.getEditor().removeArea((IArea)selected);
				toolKit.getEditor().setSelected(null);
				setNeedsUpdate(true, true);
			}
		}
	}

	@Override
	public void keyReleased(KeyEvent e) {
	}

	@Override
	public void mouseDoubleClick(MouseEvent e) {
	}

	@Override
	public void mouseDown(MouseEvent e) {
		if (!processJointPress(e) && active == null) {
			first = new Location((double) e.x, (double) e.y);
			second = new Location((double) e.x, (double) e.y);
		}
	}

	@Override
	public void mouseMove(MouseEvent e) {
		if (second != null) {
			second.x = e.x;
			second.y = e.y;
			setNeedsUpdate(true, false);
		}
	}

	@Override
	public void mouseUp(MouseEvent e) {
		if (first != null && first.getX() != second.getX()
				&& first.getY() != second.getY()) {
			if (active == null) {
				PolygonArea pa = new PolygonArea();
				pa.setShapeHint(PolygonArea.Shape.RECT);
				pa.addPoint(first);
				pa.addPoint(new Location(first.x, second.y));
				pa.addPoint(second);
				pa.addPoint(new Location(second.x, first.y));
				toolKit.getEditor().addArea(pa);
				toolKit.getEditor().setSelected(pa);
			} else {
				active.removeAllPoints();
				active.addPoint(first);
				active.addPoint(new Location(first.x, second.y));
				active.addPoint(second);
				active.addPoint(new Location(second.x, first.y));
				toolKit.getEditor().updateArea(active);
				toolKit.getEditor().setSelected(active);
				active = null;
			}
			setNeedsUpdate(true, true);
		}
		first = null;
		second = null;
	}

	@Override
	public void jointPressed(PolygonArea poly, Location location, int jointNumber) {
		active = poly;
		second = location;
		switch (jointNumber) {
		case 0:
			first = active.getPoint(2);
			break;
		case 1:
			first = active.getPoint(3);
			break;
		case 2:
			first = active.getPoint(0);
			break;
		case 3:
			first = active.getPoint(1);
			break;
		}
	}
}
