package cz.cuni.amis.pogamut.edu.map.editor.visual.tools;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.edu.map.editor.Activator;
import cz.cuni.amis.pogamut.edu.map.editor.Constants;
import cz.cuni.amis.pogamut.edu.map.editor.utils.ColorConvertor;
import cz.cuni.amis.pogamut.edu.map.editor.utils.ICoordsTransformer;
import cz.cuni.amis.pogamut.edu.map.editor.visual.ToolKit;
import cz.cuni.amis.pogamut.edu.map.marks.Path;
import cz.cuni.amis.pogamut.edu.map.marks.PathPoint;

public class PathTool extends Tool implements MouseListener, MouseMoveListener,
		KeyListener {

	static {
		Activator.getDefault().getImageRegistry().put("pathtool",
			Activator.getImageDescriptor("icons/pathtool.gif"));
	};

	protected Path constructed = null;
	protected int dragged = -1;
	protected PathDialog pathDialog;

	public PathTool(ToolKit toolKit) {
		super(toolKit, SWT.RADIO, "pathtool", "Path tool");
	}

	@Override
	public void drawDirect(GC gc, ICoordsTransformer coordsTransformer) {
		if (constructed != null) {
			ArrayList<Point> converted = new ArrayList<Point>();
			Point last = null;
			gc.setAlpha(255);
			gc.setForeground(ColorConvertor.awt2swt(constructed.getColor()));
			gc.setLineCap(SWT.CAP_ROUND);
			gc.setLineWidth((int) Math.ceil(constructed.getWidth()));
			for (PathPoint p : constructed.getPoints()) {
				Point p2 = coordsTransformer.location2client(p.getLocation());
				converted.add(p2);
				if (last != null) {
					gc.drawLine(last.x, last.y, p2.x, p2.y);
				}
				last = p2;
			}
			gc.setLineWidth(1);
			gc.setBackground(Constants.WHITE);
			gc.setForeground(Constants.BLACK);
			for (Point p2 : converted) {
				gc.fillRectangle(p2.x - 3, p2.y - 3, 6, 6);
				gc.drawRectangle(p2.x - 3, p2.y - 3, 6, 6);
			}
		}
	}

	@Override
	public void keyPressed(KeyEvent e) {
		if (e.keyCode == SWT.DEL || e.keyCode == SWT.BS) {
			Object selected = toolKit.getEditor().getSelected();
			if (selected != null && selected != constructed && selected instanceof Path) {
				toolKit.getEditor().removeMark((Path) selected);
				setNeedsUpdate(true, true);
			} else if (constructed != null && constructed.getNumPoints() != 0) {
				constructed.removePoint(constructed.getNumPoints() - 1);
				if (toolKit.getEditor().getMark(constructed.getName()) == null) {
					toolKit.getEditor().setDirty();
				}
				setNeedsUpdate(true, true);
			}
		} else if (e.keyCode == SWT.ESC) {
			constructed = null;
			setNeedsUpdate(true, true);
		} else if (e.keyCode == SWT.CR || e.keyCode == SWT.LF) {
			if (toolKit.getEditor().getMapData().getMark(constructed.getName()) == null) {
				toolKit.getEditor().addMark(constructed);
				toolKit.getEditor().setSelected(constructed);
			} else {
				toolKit.getEditor().setDirty();
			}
			constructed = null;
			setNeedsUpdate(true, true);
		}
	}

	@Override
	public void keyReleased(KeyEvent e) {
	}

	@Override
	public void mouseDoubleClick(MouseEvent e) {
	}

	@Override
	public void mouseDown(MouseEvent e) {
		if (constructed == null) {
			Object selected = toolKit.getEditor().getSelected();
			if (selected != null && selected instanceof Path) {
				int i = 0;
				for (PathPoint p : ((Path) selected).getPoints()) {
					if (toolKit.getEditor().isClose(p.getLocation(),
						new Location((double) e.x, (double) e.y, (double) 0))) {
						dragged = i;
						break;
					}
					++i;
				}
			}
			if (dragged != -1) {
				constructed = (Path) selected;
			} else {
				constructed = new Path();
				if (pathDialog == null) {
					pathDialog = new PathDialog(toolKit.getEditor().getShell());
				}
				pathDialog.setId("");
				pathDialog.setColor(constructed.getColor());
				pathDialog.setWidth(constructed.getWidth());
				pathDialog.open("New path");
				if (pathDialog.getResult()) {
					if (!pathDialog.getId().isEmpty()) {
						if (toolKit.getEditor().isIdUsed(pathDialog.getId())) {
							error("This ID is already in use.");
							constructed = null;
							return;
						}
						constructed.setName(pathDialog.getId());
					}
					constructed.setColor(pathDialog.getColor());
					constructed.setWidth(pathDialog.getWidth());
					constructed.addPoint(new PathPoint(e.x, e.y));
					toolKit.getEditor().setSelected(constructed);
				} else {
					constructed = null;
				}
			}
			setNeedsUpdate(true, true);
		} else {
			int i = 0;
			for (PathPoint p : constructed.getPoints()) {
				if (toolKit.getEditor().isClose(p.getLocation(),
					new Location((double) e.x, (double) e.y, (double) 0))) {
					dragged = i;
					break;
				}
				++i;
			}
			if (dragged == -1) {
				constructed.addPoint(new PathPoint(e.x, e.y));
				setNeedsUpdate(true, false);
			}
			toolKit.getEditor().setSelected(constructed);
		}

	}

	@Override
	public void mouseUp(MouseEvent e) {
		if (dragged != -1) {
			dragged = -1;
			setNeedsUpdate(true, true);
		}
	}

	@Override
	public void widgetSelected(SelectionEvent e) {
		super.widgetSelected(e);
		if (constructed != null) {
			toolKit.getEditor().setSelected(constructed);
		}
		toolKit.getEditor().getWorkField().update(true);
	}

	@Override
	public void mouseMove(MouseEvent e) {
		if (dragged != -1) {
			constructed.getPoint(dragged).setLocation(
				new Location((double) e.x, (double) e.y, (double) 0));
			setNeedsUpdate(true, false);
			if (constructed != toolKit.getEditor().getSelected()) {
				toolKit.getEditor().setDirty();
			}
		}
	}
}
