package cz.cuni.amis.pogamut.edu.map.editor.visual.tools;

import java.awt.Color;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.edu.map.editor.Activator;
import cz.cuni.amis.pogamut.edu.map.editor.Constants;
import cz.cuni.amis.pogamut.edu.map.editor.utils.ICoordsTransformer;
import cz.cuni.amis.pogamut.edu.map.editor.visual.ToolKit;
import cz.cuni.amis.pogamut.edu.map.marks.POI;

public class POITool extends Tool implements MouseListener, MouseMoveListener,
		KeyListener {

	static {
		Activator.getDefault().getImageRegistry().put("poitool",
			Activator.getImageDescriptor("icons/poitool.gif"));
	};

	protected POI active;
	protected POIDialog poiDialog;

	public POITool(ToolKit toolKit) {
		super(toolKit, SWT.RADIO, "poitool", "POI tool");
	}

	@Override
	public void drawDirect(GC gc, ICoordsTransformer coordsTransformer) {
		if (active != null) {
			gc.setAlpha(128);
			Color c = active.getColor();
			gc.setForeground(new org.eclipse.swt.graphics.Color(null,
					c.getRed(), c.getGreen(), c.getBlue()));
			String symbol = "[" + active.getSymbol().toString() + "]";
			Point p = gc.stringExtent(symbol);
			Point p2 = coordsTransformer.location2client(active.getLocation());
			gc.drawText(symbol, p2.x - p.x / 2, p2.y - p.y - 5, true);
			p = gc.stringExtent(active.getDescription());
			gc
				.drawText(active.getDescription(), p2.x - p.x / 2, p2.y + 5,
					true);
			gc.setBackground(Constants.WHITE);
			gc.setForeground(Constants.BLACK);
			gc.fillRectangle(p2.x - 3, p2.y - 3, 6, 6);
			gc.drawRectangle(p2.x - 3, p2.y - 3, 6, 6);
		}
	}

	@Override
	public void keyPressed(KeyEvent e) {
		if (e.keyCode == SWT.DEL || e.keyCode == SWT.BS) {
			Object selected = toolKit.getEditor().getSelected();
			if (selected != null && selected instanceof POI) {
				toolKit.getEditor().removeMark((POI)selected);
				setNeedsUpdate(true, true);
			}
		}
	}

	@Override
	public void keyReleased(KeyEvent e) {
	}

	@Override
	public void mouseDoubleClick(MouseEvent e) {
	}

	@Override
	public void mouseDown(MouseEvent e) {
		Object selected = toolKit.getEditor().getSelected(); 
		if (selected != null && selected instanceof POI) {
			active = (POI) selected;
		} else {
			if (poiDialog == null) {
				poiDialog = new POIDialog(toolKit.getEditor().getShell());
			}
			poiDialog.setId("");
			poiDialog.setDescription("");
			poiDialog.setColor(Color.RED);
			poiDialog.setSymbol(POI.Symbol.NONE);
			poiDialog.setVisible(false);
			poiDialog.open("New POI");
			if (poiDialog.getResult()) {
				POI poi = new POI();
				if (!poiDialog.getId().isEmpty()) {
					if (toolKit.getEditor().isIdUsed(poiDialog.getId())) {
						error("This ID is already in use.");
						return;
					}
					poi.setName(poiDialog.getId());
				}
				poi.setDescription(poiDialog.getDescription());
				poi.setColor(poiDialog.getColor());
				poi.setSymbol(poiDialog.getSymbol());
				poi.setVisible(poiDialog.getVisible());
				poi.setLocation(new Location((double) e.x, (double) e.y,
						(double) 0));
				toolKit.getEditor().addMark(poi);
				setNeedsUpdate(true, true);
			}
		}
	}

	@Override
	public void mouseUp(MouseEvent e) {
		if (active != null) {
			active.setLocation(new Location((double) e.x, (double) e.y,
					(double) 0));
			toolKit.getEditor().setDirty();
			setNeedsUpdate(true, true);
		}
		active = null;
	}

	@Override
	public void mouseMove(MouseEvent e) {
		if (active != null) {
			active.getLocation().x = e.x;
			active.getLocation().y = e.y;
			setNeedsUpdate(true, false);
		}
	}
}
