package cz.cuni.amis.pogamut.edu.map.editor.visual.tools;

import java.awt.Color;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import cz.cuni.amis.pogamut.edu.map.marks.POI;
import cz.cuni.amis.pogamut.edu.utils.ColorTable;

public class POIDialog extends Dialog {
	protected Color color;
	protected String description;
	protected String id;
	protected boolean result;
	protected POI.Symbol symbol;
	protected boolean visible;

	public POIDialog(Shell parent) {
		super(parent);
	}
	
	public Color getColor() {
		return color;
	}

	public String getDescription() {
		return description;
	}

	public String getId() {
		return id;
	}

	public boolean getResult() {
		return result;
	}

	public POI.Symbol getSymbol() {
		return symbol;
	}
	
	public boolean getVisible() {
		return visible;
	}

	public void open(String title) {
		final Shell shell = new Shell(getParent(), SWT.DIALOG_TRIM
				| SWT.APPLICATION_MODAL);
		shell.setText(title);
		GridLayout layout = new GridLayout(3, true);
		shell.setLayout(layout);
		GridData gd = new GridData();
		gd.horizontalSpan = 2;
		Label idLabel = new Label(shell, SWT.NULL);
		idLabel.setText("Id:");
		final Text idText = new Text(shell, SWT.BORDER | SWT.SINGLE);
		idText.setLayoutData(gd);
		idText.setText(id);
		Label descLabel = new Label(shell, SWT.NULL);
		descLabel.setText("Description:");
		final Text descText = new Text(shell, SWT.BORDER | SWT.SINGLE);
		descText.setLayoutData(gd);
		descText.setText(description);
		Label symbolLabel = new Label(shell, SWT.NULL);
		symbolLabel.setText("Symbol:");
		final Combo symbolCombo = new Combo(shell, SWT.DROP_DOWN
				| SWT.READ_ONLY | SWT.BORDER);
		symbolCombo.setLayoutData(gd);
		int i = 0, selected = 0;
		for (POI.Symbol s : POI.Symbol.values()) {
			symbolCombo.add(s.toString());
			if (s.equals(symbol)) {
				selected = i;
			}
			++i;
		}
		symbolCombo.select(selected);
		Label visibleText = new Label(shell, SWT.NULL);
		visibleText.setText("Visible:");
		final Combo visibleCombo = new Combo(shell, SWT.DROP_DOWN
			| SWT.READ_ONLY | SWT.BORDER);
		visibleCombo.setLayoutData(gd);
		visibleCombo.add("false");
		visibleCombo.add("true");
		visibleCombo.select(visible?1:0);		
		Label colorLabel = new Label(shell, SWT.NULL);
		colorLabel.setText("Color:");
		final Text colorText = new Text(shell, SWT.SINGLE | SWT.BORDER);
		colorText.setText(ColorTable.getNameFor(color));
		Button colorButton = new Button(shell, SWT.PUSH);
		colorButton.setText("Select...");
		colorButton.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				ColorDialog dialog = new ColorDialog(shell);
				dialog.setText("POI color");
				dialog.setRGB(new RGB(255, 0, 0));
				RGB rgb = dialog.open();
				colorText.setText(ColorTable.getNameFor(new Color(rgb.red,
						rgb.green, rgb.blue)));
			}
		});
		Button ok = new Button(shell, SWT.PUSH);
		ok.setText("OK");
		GridData gd2 = new GridData();
		gd2.horizontalAlignment = SWT.RIGHT;
		ok.setLayoutData(gd2);
		ok.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				result = true;
				id = idText.getText();
				description = descText.getText();
				symbol = POI.Symbol
									.valueOf(symbolCombo
														.getItem(symbolCombo
																			.getSelectionIndex()));
				visible = visibleCombo.getSelectionIndex() != 0;
				color = ColorTable.getColorFor(colorText.getText());
				shell.close();
			}

		});
		Button storno = new Button(shell, SWT.PUSH);
		storno.setText("Storno");
		storno.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				result = false;
				shell.close();
			}

		});
		shell.pack();
		shell.open();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
	}

	public void setColor(Color color) {
		this.color = color;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public void setId(String id) {
		this.id = id;
	}

	public void setSymbol(POI.Symbol symbol) {
		this.symbol = symbol;
	}
	
	public void setVisible(boolean visible) {
		this.visible = visible;
	}
}
