package cz.cuni.amis.pogamut.edu.map.editor.visual.tools;

import cz.cuni.amis.pogamut.edu.map.areas.IArea;
import cz.cuni.amis.pogamut.edu.map.editor.Activator;
import cz.cuni.amis.pogamut.edu.map.editor.visual.ToolKit;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;

public class LockTool extends Tool {

	static {
		Activator.getDefault().getImageRegistry().put("lock",
			Activator.getImageDescriptor("icons/lock.gif"));
	}

	public LockTool(ToolKit toolKit) {
		super(toolKit, SWT.CHECK, "lock", "Lock selection");
	}

	@Override
	public void widgetSelected(SelectionEvent e) {
		if (toolKit.getEditor().getLocked() == null) {
			Object selected = toolKit.getEditor().getSelected();
			if (selected != null && selected instanceof IArea) {
				toolKit.getEditor().setLocked((IArea)selected);
				toolKit.getEditor().setSelected(null);
				item.setSelection(true);
			} else {
				item.setSelection(false);
			}
		} else {
			toolKit.getEditor().setLocked(null);
			item.setSelection(false);
		}
		toolKit.getEditor().getWorkField().update(true);
	}

}
