package cz.cuni.amis.pogamut.edu.map.editor.visual.tools;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import cz.cuni.amis.pogamut.edu.map.areas.CompoundArea;
import cz.cuni.amis.pogamut.edu.map.areas.IArea;
import cz.cuni.amis.pogamut.edu.map.editor.Activator;
import cz.cuni.amis.pogamut.edu.map.editor.visual.ToolKit;

public class GoToSuperiorTool extends Tool {
	
	static {
		Activator.getDefault().getImageRegistry().put("gotosuperior",
			Activator.getImageDescriptor("icons/gotosuperior.gif"));
	}
	
	protected class InfoDialog extends Dialog {
		protected String type;
		protected String id;
		protected boolean result;
		
		public boolean getResult() {
			return result;
		}

		public InfoDialog(Shell parent) {
			super(parent);
		}
		
		public void open () {
			Shell parent = getParent();
			final Shell shell = new Shell(parent, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
			shell.setText("No upper area.");
			GridLayout layout = new GridLayout(2, true);
			shell.setLayout(layout);
			GridData gd = new GridData();
			gd.horizontalSpan = 2;
			Label infoLabel = new Label(shell, 0);
			infoLabel.setLayoutData(gd);
			infoLabel.setText("The selected area hasn't any superior area.\nWould you like to create one?");
			GridData gd2 = new GridData();
			gd2.horizontalAlignment = SWT.RIGHT;
			gd2.verticalAlignment= SWT.CENTER;
			Label typeLabel = new Label(shell, 0);
			typeLabel.setText("Type:");
			typeLabel.setLayoutData(gd2);
			final Text typeText = new Text(shell, SWT.BORDER);
			Label idLabel = new Label(shell, 0);
			idLabel.setText("Id:");
			idLabel.setLayoutData(gd2);
			final Text idText = new Text(shell, SWT.BORDER);
			Button yes = new Button(shell, SWT.PUSH);
			yes.setText("Yes");
			yes.setLayoutData(gd2);
			yes.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					result = true;
					type = typeText.getText();
					id = idText.getText();
					shell.close();					
				}
				
			});
			Button no = new Button(shell, SWT.PUSH);
			no.setText("No");
			no.addSelectionListener(new SelectionAdapter(){
				@Override
				public void widgetSelected(SelectionEvent e) {
					result = false;
					shell.close();					
				}
				
			});
			shell.pack();
			shell.open();
			Display display = parent.getDisplay();
			while (!shell.isDisposed()) {
				if (!display.readAndDispatch()) display.sleep();
			}
		}

		public String getType() {
			return type;
		}

		public String getId() {
			return id;
		}
	}
	
	protected InfoDialog infoDialog;

	public GoToSuperiorTool(ToolKit toolKit) {
		super(toolKit, SWT.PUSH, "gotosuperior", "Select superior area");
	}

	protected void openInfoDialog() {
		if (infoDialog == null) {
			infoDialog = new InfoDialog(toolKit.getEditor().getShell());
		}
		infoDialog.open();
	}
	
	@Override
	public void widgetSelected(SelectionEvent e) {
		Object selected = toolKit.getEditor().getSelected();
		if (selected != null && selected instanceof IArea) {
			IArea area = (IArea)selected;
			IArea superior = area.getSuperior();
			if (superior == toolKit.getEditor().getMapRootArea()) {
				openInfoDialog();
				if (infoDialog.getResult()) {
					if (toolKit.getEditor().isIdUsed(infoDialog.getId())) {
						error("This ID is already in use.");
						return;
					}
					CompoundArea ca = new CompoundArea();
					ca.setType(infoDialog.getType());
					ca.setName(infoDialog.getId());
					ca.add(area);
					area.getSuperior().remove(area);
					area.setSuperior(ca);
					toolKit.getEditor().addArea(ca);
					toolKit.getEditor().setSelected(ca);
					toolKit.getEditor().getWorkField().update(true);
				}					
			} else {
				toolKit.getEditor().setSelected(superior);
				toolKit.getEditor().getWorkField().update(true);
			}
		}
		toolKit.setActiveTool(SelectTool.class);
	}
}
