package cz.cuni.amis.pogamut.edu.map.editor.visual.tools;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;

import cz.cuni.amis.pogamut.edu.map.areas.IArea;
import cz.cuni.amis.pogamut.edu.map.areas.IComplexArea;
import cz.cuni.amis.pogamut.edu.map.areas.ICompoundArea;
import cz.cuni.amis.pogamut.edu.map.editor.Activator;
import cz.cuni.amis.pogamut.edu.map.editor.visual.ToolKit;

public class ExcludeTool extends Tool {
	static {
		Activator.getDefault().getImageRegistry().put("excludetool",
			Activator.getImageDescriptor("icons/excludetool.gif"));
	}

	public ExcludeTool(ToolKit toolKit) {
		super(toolKit, SWT.PUSH, "excludetool", "Exclude from locked area");
	}
	
	@Override
	public void widgetSelected(SelectionEvent e) {
		Object selected = toolKit.getEditor().getSelected();
		if (!(selected instanceof IArea)) {
			error("Selected object is not an area!");
			return;
		}
		IArea locked = toolKit.getEditor().getLocked();
		if (locked == null) {
			error("Nothing is locked, cannot proceed.");
			return;
		}
		if (locked instanceof ICompoundArea) {
			ICompoundArea ca = (ICompoundArea) locked; 
			if (selected instanceof IComplexArea
					&& ((IComplexArea) selected).containsExactly(locked)) {
				error("Locked area is in selected area!");
				return;
			}
			((IArea)selected).getSuperior().remove((IArea)selected);
			ca.exclude((IArea)selected);
			((IArea)selected).setSuperior(ca.getExcludedArea());
		} else {
			error("Cannot remove from locked area - the locked area is only a simple shape.");
			return;
		}
		toolKit.getEditor().getWorkField().update(true);
	}
}
