package cz.cuni.amis.pogamut.edu.map.editor.visual.tools;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import cz.cuni.amis.pogamut.edu.map.areas.ICompoundArea;
import cz.cuni.amis.pogamut.edu.map.editor.Activator;
import cz.cuni.amis.pogamut.edu.map.editor.visual.ToolKit;
import cz.cuni.amis.pogamut.edu.map.marks.POI;
import cz.cuni.amis.pogamut.edu.map.marks.Path;

public class EditTool extends Tool {
	static {
		Activator.getDefault().getImageRegistry().put("edit",
			Activator.getImageDescriptor("icons/edit.gif"));
	}

	protected class EditAreaDialog extends Dialog {
		protected String type;
		protected String id;
		protected boolean result;

		public boolean getResult() {
			return result;
		}

		public EditAreaDialog(Shell parent) {
			super(parent);
		}

		public void open(String prevName, String prevType) {
			Shell parent = getParent();
			final Shell shell = new Shell(parent, SWT.DIALOG_TRIM
					| SWT.APPLICATION_MODAL);
			shell.setText("No upper area.");
			GridLayout layout = new GridLayout(2, true);
			shell.setLayout(layout);
			GridData gd2 = new GridData();
			gd2.horizontalAlignment = SWT.RIGHT;
			gd2.verticalAlignment = SWT.CENTER;
			Label typeLabel = new Label(shell, 0);
			typeLabel.setText("Type:");
			typeLabel.setLayoutData(gd2);
			final Text typeText = new Text(shell, SWT.BORDER);
			typeText.setText(prevType);
			Label idLabel = new Label(shell, 0);
			idLabel.setText("Id:");
			idLabel.setLayoutData(gd2);
			final Text idText = new Text(shell, SWT.BORDER);
			idText.setText(prevName);
			Button ok = new Button(shell, SWT.PUSH);
			ok.setText("OK");
			ok.setLayoutData(gd2);
			ok.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					result = true;
					type = typeText.getText();
					id = idText.getText();
					shell.close();
				}

			});
			Button storno = new Button(shell, SWT.PUSH);
			storno.setText("Storno");
			storno.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					result = false;
					shell.close();
				}

			});
			shell.pack();
			shell.open();
			Display display = parent.getDisplay();
			while (!shell.isDisposed()) {
				if (!display.readAndDispatch())
					display.sleep();
			}
		}

		public String getType() {
			return type;
		}

		public String getId() {
			return id;
		}
	}

	protected EditAreaDialog editAreaDialog;
	protected POIDialog poiDialog;
	protected PathDialog pathDialog;

	public EditTool(ToolKit toolKit) {
		super(toolKit, SWT.PUSH, "edit", "Edit");
	}

	@Override
	public void widgetSelected(SelectionEvent e) {
		Object selected = toolKit.getEditor().getSelected();
		if (selected != null) {
			if (selected instanceof ICompoundArea) {
				ICompoundArea area = (ICompoundArea) selected;
				if (editAreaDialog == null) {
					editAreaDialog = new EditAreaDialog(toolKit.getEditor()
																.getShell());
				}
				editAreaDialog.open(area.getName(), area.getType());
				if (editAreaDialog.getResult()) {
					if (!editAreaDialog.getId().equals(area.getName())
							&& toolKit.getEditor().isIdUsed(
								editAreaDialog.getId())) {
						error("This ID is already in use.");
						return;
					}
					area.setName(editAreaDialog.getId());
					area.setType(editAreaDialog.getType());
					toolKit.getEditor().updateArea(area);
				}
			} else if (selected instanceof POI) {
				POI poi = (POI) selected;
				if (poiDialog == null) {
					poiDialog = new POIDialog(toolKit.getEditor().getShell());
				}
				poiDialog.setId(poi.getName());
				poiDialog.setDescription(poi.getDescription());
				poiDialog.setColor(poi.getColor());
				poiDialog.setVisible(poi.isVisible());
				poiDialog.setSymbol(poi.getSymbol());
				poiDialog.open("Edit POI");
				if (poiDialog.getResult()) {
					if (!poiDialog.getId().isEmpty()
							&& !poiDialog.getId().equals(poi.getName())) {
						if (toolKit.getEditor().isIdUsed(poiDialog.getId())) {
							error("This ID is already in use.");
							return;
						}
						poi.setName(poiDialog.getId());
					}
					poi.setDescription(poiDialog.getDescription());
					poi.setColor(poiDialog.getColor());
					poi.setVisible(poiDialog.getVisible());
					poi.setSymbol(poiDialog.getSymbol());
					toolKit.getEditor().getWorkField().update(true);
					toolKit.getEditor().updateMark(poi);
				}
			} else if (selected instanceof Path) {
				Path path = (Path) selected;
				if (pathDialog == null) {
					pathDialog = new PathDialog(toolKit.getEditor().getShell());
				}
				pathDialog.setId(path.getName());
				pathDialog.setWidth(path.getWidth());
				pathDialog.setColor(path.getColor());
				pathDialog.setVisible(path.isVisible());
				pathDialog.open("Edit path");
				if (pathDialog.getResult()) {
					if (!pathDialog.getId().isEmpty()
							&& !pathDialog.getId().equals(path.getName())) {
						if (toolKit.getEditor().isIdUsed(pathDialog.getId())) {
							error("This ID is already in use.");
							return;
						}
						path.setName(pathDialog.getId());
					}
					path.setWidth(pathDialog.getWidth());
					path.setColor(pathDialog.getColor());
					path.setVisible(pathDialog.getVisible());
					toolKit.getEditor().getWorkField().update(true);
					toolKit.getEditor().updateMark(path);
				}
			} else {
				MessageBox mb = new MessageBox(toolKit.getEditor().getShell(),
						SWT.OK | SWT.ICON_ERROR);
				mb.setMessage("The selected object cannot be edited.");
				mb.setText("Unable to edit");
				mb.open();
			}
		}
	}
}
