package cz.cuni.amis.pogamut.edu.map.editor.visual.tools;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import cz.cuni.amis.pogamut.edu.map.MapData;
import cz.cuni.amis.pogamut.edu.map.editor.Activator;
import cz.cuni.amis.pogamut.edu.map.editor.utils.AllowOnlyNumbers;
import cz.cuni.amis.pogamut.edu.map.editor.visual.ToolKit;

public class EditPlanTool extends Tool {
	protected class EditDialog extends Dialog {
		protected double originX;
		protected double originY;
		protected double scale;
		protected String src;
		protected String unrealId;
		protected boolean result;

		public EditDialog(Shell parent) {
			super(parent);
		}

		public void open() {
			Shell parent = getParent();
			final Shell shell = new Shell(parent, SWT.DIALOG_TRIM
					| SWT.APPLICATION_MODAL);
			shell.setText("No upper area.");
			GridLayout gl = new GridLayout(3, false);
			shell.setLayout(gl);
			new Label(shell, SWT.NONE).setText("Plan image:");
			final Text srcText = new Text(shell, SWT.BORDER);
			srcText.setText(src==null?"":src);
			Button browse = new Button(shell, SWT.PUSH);
			browse.setText("Browse...");
			browse.addSelectionListener(new SelectionAdapter() {

				@Override
				public void widgetSelected(SelectionEvent e) {
					FileDialog dialog = new FileDialog(shell);
					dialog.setFilterNames(new String[] { "Image Files",
							"All Files (*.*)" });
					dialog.setFilterExtensions(new String[] {
							"*.gif;*.png;*.bmp;*.jpg;*.jpeg;*.tiff", "*.*" });
					srcText.setText(dialog.open());
				}

			});
			Listener allowOnlyNumbers = new AllowOnlyNumbers();
			GridData gd = new GridData();
			gd.horizontalSpan = 2;
			new Label(shell, SWT.NONE).setText("UnrealId:");
			final Text unrealIdText = new Text(shell, SWT.BORDER);
			unrealIdText.setText(unrealId==null?"":unrealId);
			unrealIdText.setLayoutData(gd);
			new Label(shell, SWT.NONE).setText("Scale:");
			final Text scaleText = new Text(shell, SWT.BORDER);
			scaleText.setText(String.valueOf(scale));
			scaleText.addListener(SWT.Verify, allowOnlyNumbers);
			scaleText.setLayoutData(gd);
			new Label(shell, SWT.NONE).setText("Origin x:");
			final Text originXText = new Text(shell, SWT.BORDER);
			originXText.setText(String.valueOf(originX));
			originXText.addListener(SWT.Verify, allowOnlyNumbers);
			originXText.setLayoutData(gd);
			new Label(shell, SWT.NONE).setText("Origin y:");
			final Text originYText = new Text(shell, SWT.BORDER);
			originYText.setText(String.valueOf(originY));
			originYText.addListener(SWT.Verify, allowOnlyNumbers);
			originYText.setLayoutData(gd);
			GridData gd2 = new GridData();
			gd2.horizontalAlignment = SWT.RIGHT;
			gd2.verticalAlignment = SWT.CENTER;
			Button rescale = new Button(shell, SWT.PUSH);
			rescale.setLayoutData(gd2);
			rescale.setText("Rescale");
			rescale.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					src = srcText.getText();
					unrealId = unrealIdText.getText();
					scale = Double.parseDouble(scaleText.getText());
					originX = Double.parseDouble(originXText.getText());
					originY = Double.parseDouble(originYText.getText());
					result = true;
					shell.close();
				}

			});
			Button storno = new Button(shell, SWT.PUSH);
			storno.setText("Storno");
			storno.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					result = false;
					shell.close();
				}
			});
			shell.pack();
			shell.open();
			Display display = parent.getDisplay();
			while (!shell.isDisposed()) {
				if (!display.readAndDispatch())
					display.sleep();
			}
		}

		public String getUnrealId() {
			return unrealId;
		}

		public void setUnrealId(String unrealId) {
			this.unrealId = unrealId;
		}

		public double getOriginX() {
			return originX;
		}

		public void setOriginX(double originX) {
			this.originX = originX;
		}

		public double getOriginY() {
			return originY;
		}

		public void setOriginY(double originY) {
			this.originY = originY;
		}

		public double getScale() {
			return scale;
		}

		public void setScale(double scale) {
			this.scale = scale;
		}

		public String getSrc() {
			return src;
		}

		public void setSrc(String src) {
			this.src = src;
		}

		public boolean getResult() {
			return result;
		}
	}

	static {
		Activator.getDefault().getImageRegistry().put("editplan",
			Activator.getImageDescriptor("icons/editplan.gif"));
	}

	protected EditDialog editDialog;

	public EditPlanTool(ToolKit toolKit) {
		super(toolKit, SWT.PUSH, "editplan", "Edit plan");
	}

	@Override
	public void widgetSelected(SelectionEvent e) {
		if (editDialog == null) {
			editDialog = new EditDialog(toolKit.getEditor().getShell());
		}
		MapData mapData = toolKit.getEditor().getMapData();
		editDialog.setSrc(mapData.getPlan());
		editDialog.setUnrealId(mapData.getPlanUnrealId());
		editDialog.setOriginX(mapData.getOriginX());
		editDialog.setOriginY(mapData.getOriginY());
		editDialog.setScale(mapData.getScale());
		editDialog.open();
		if (editDialog.getResult()) {
			mapData.setPlan(editDialog.getSrc());
			mapData.setPlanUnrealId(editDialog.getUnrealId());
			mapData.setOriginX(editDialog.getOriginX());
			mapData.setOriginY(editDialog.getOriginY());
			mapData.setScale(editDialog.getScale());
			toolKit.getEditor().setDirty();
		}
	}
}
