package cz.cuni.amis.pogamut.edu.map.editor.visual.tools;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.edu.map.areas.IArea;
import cz.cuni.amis.pogamut.edu.map.areas.PolygonArea;
import cz.cuni.amis.pogamut.edu.map.editor.Activator;
import cz.cuni.amis.pogamut.edu.map.editor.Constants;
import cz.cuni.amis.pogamut.edu.map.editor.utils.ICoordsTransformer;
import cz.cuni.amis.pogamut.edu.map.editor.visual.ToolKit;

public class CircleTool extends AbstractPolyTool implements MouseListener,
		MouseMoveListener, KeyListener {

	protected enum Action {
		CREATING, MOVING, RESIZING
	}

	static {
		Activator.getDefault().getImageRegistry().put("circletool",
			Activator.getImageDescriptor("icons/circletool.gif"));
	};

	protected Action action = Action.CREATING;
	protected PolygonArea active;
	protected Location center;
	protected double radius;

	public CircleTool(ToolKit toolKit) {
		super(toolKit, SWT.RADIO, "circletool", "Circle tool");
	}

	@Override
	public void drawDirect(GC gc, ICoordsTransformer coordsTransformer) {
		if (center != null) {
			gc.setForeground(Constants.BLACK);
			gc.setBackground(Constants.WHITE);
			Point p = coordsTransformer.location2client(center);
			gc.drawRectangle(p.x - 3, p.y - 3, 6, 6);
			gc.fillRectangle(p.x - 3, p.y - 3, 6, 6);
			int rad = (int) coordsTransformer.distance2client(radius);
			gc.drawArc(p.x - rad, p.y - rad, 2 * rad, 2 * rad, 0, 360);
		}
	}

	@Override
	public void keyPressed(KeyEvent e) {
		if (e.keyCode == SWT.DEL || e.keyCode == SWT.BS) {
			Object selected = toolKit.getEditor().getSelected();
			if (selected != null && selected instanceof IArea) {
				toolKit.getEditor().removeArea((IArea) selected);
				toolKit.getEditor().setSelected(null);
				setNeedsUpdate(true, true);
			}
		}
	}

	@Override
	public void keyReleased(KeyEvent e) {
	}

	@Override
	public void mouseDoubleClick(MouseEvent e) {
	}

	@Override
	public void mouseDown(MouseEvent e) {
		if (!processJointPress(e) && active == null) {
			center = new Location((double) e.x, (double) e.y);
			radius = 0;
		}
	}

	@Override
	public void mouseMove(MouseEvent e) {
		if (active == null) {
			if (center != null) {
				radius = Math.sqrt((center.x - e.x) * (center.x - e.x)
						+ (center.y - e.y) * (center.y - e.y));
				setNeedsUpdate(true, false);
			}
		} else {
			if (action == Action.MOVING) {
				center.x = e.x;
				center.y = e.y;
			} else {
				radius = Math.sqrt((center.x - e.x) * (center.x - e.x)
						+ (center.y - e.y) * (center.y - e.y));
			}
			setNeedsUpdate(true, false);
		}
	}

	@Override
	public void mouseUp(MouseEvent e) {
		if (active == null) {
			if (radius > 0) {
				PolygonArea pa = new PolygonArea();
				pa.generateCircle(center.x, center.y, radius);
				toolKit.getEditor().addArea(pa);
				toolKit.getEditor().setSelected(pa);
			}
		} else {
			active.generateCircle(center.x, center.y, radius);
			toolKit.getEditor().updateArea(active);
			toolKit.getEditor().setSelected(active);
			active = null;
			action = Action.CREATING;
		}
		center = null;
		setNeedsUpdate(true, true);
	}

	@Override
	public void jointPressed(PolygonArea poly, Location location,
			int jointNumber) {
		active = poly;
		center = poly.getCenter();
		if (jointNumber == -1) {
			action = Action.MOVING;
			Location l = active.getPoint(0);
			radius = Math.sqrt((center.x - l.x) * (center.x - l.x)
					+ (center.y - l.y) * (center.y - l.y));
		} else {
			action = Action.RESIZING;
			radius = Math.sqrt((center.x - location.x)
					* (center.x - location.x) + (center.y - location.y)
					* (center.y - location.y));
		}
	}
}
