package cz.cuni.amis.pogamut.edu.map.editor.visual.tools;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;

import cz.cuni.amis.pogamut.edu.map.areas.IArea;
import cz.cuni.amis.pogamut.edu.map.areas.IComplexArea;
import cz.cuni.amis.pogamut.edu.map.areas.ICompoundArea;
import cz.cuni.amis.pogamut.edu.map.editor.Activator;
import cz.cuni.amis.pogamut.edu.map.editor.visual.ToolKit;

public class AddToLockedTool extends Tool {

	static {
		Activator.getDefault().getImageRegistry().put("addtolocked",
			Activator.getImageDescriptor("icons/addtolocked.gif"));
	}

	public AddToLockedTool(ToolKit toolKit) {
		super(toolKit, SWT.PUSH, "addtolocked", "Add to locked area");
	}

	@Override
	public void widgetSelected(SelectionEvent e) {
		Object selected = toolKit.getEditor().getSelected();
		IArea locked = toolKit.getEditor().getLocked();
		if (locked == null) {
			error("Nothing is locked, cannot proceed.");
			return;
		}
		if (locked instanceof IComplexArea) {
			if (!(selected instanceof IArea)) {
				error("Selected object is not an area!");
				return;
			}
			IComplexArea ca = (IComplexArea) locked;
			if (ca.containsExactly((IArea)selected)) {
				error("Selected area is already in!");
				return;
			}
			if (selected instanceof IComplexArea
					&& ((IComplexArea) selected).containsExactly(locked)) {
				error("Locked area is in selected area!");
				return;
			}
			if (locked instanceof ICompoundArea) {
				ICompoundArea ca2 = (ICompoundArea)locked;
				if (ca2.getExcludedArea().containsExactly((IArea)selected)) {
					ca2.reinclude((IArea)selected);
				}
			}
			((IArea)selected).getSuperior().remove((IArea)selected);
			ca.add((IArea)selected);
			((IArea)selected).setSuperior(ca);
		} else {
			error("Cannot add to locked area - the locked area is only a simple shape.");
			return;
		}
		toolKit.getEditor().getWorkField().update(true);
	}
}