package cz.cuni.amis.pogamut.edu.map.editor.visual.tools;

import org.eclipse.swt.events.MouseEvent;

import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.edu.map.areas.PolygonArea;
import cz.cuni.amis.pogamut.edu.map.editor.visual.ToolKit;

public abstract class AbstractPolyTool extends Tool {

	public AbstractPolyTool(ToolKit toolKit, int style, String image,
			String toolTip) {
		super(toolKit, style, image, toolTip);
	}

	/**
	 * Tests if we pressed some PolygonArea's joint (corner) and
	 * processes apropriate tool's jointPressed method to reflect
	 * this change.
	 * 
	 * @param e
	 * @return true if the joint was pressed, false otherwise
	 */
	public boolean processJointPress(MouseEvent e) {
		Object selected = toolKit.getEditor().getSelected();
		if (selected != null && selected instanceof PolygonArea) {
			PolygonArea poly = (PolygonArea)selected;
			int i;
			Location loc = new Location((double) e.x, (double) e.y);
			if (poly.getShapeHint() == PolygonArea.Shape.CIRCLE) {
				if (toolKit.getEditor().isClose(loc, poly.getCenter())) {
					toolKit.setActiveTool(CircleTool.class);
					((CircleTool)toolKit.getActiveTool()).jointPressed(poly, loc, -1);
					return true;
				}
			}
			for (i = 0; i < poly.getNumPoints(); ++i) {
				if (toolKit.getEditor().isClose(loc, poly.getPoint(i))) {
					break;
				}
			}
			if (i < poly.getNumPoints()) {
				switch (((PolygonArea)selected).getShapeHint()) {
				case RECT:
					toolKit.setActiveTool(RectTool.class);
					((RectTool)toolKit.getActiveTool()).jointPressed(poly, loc, i);
					return true;
				case CIRCLE:
					toolKit.setActiveTool(CircleTool.class);
					((CircleTool)toolKit.getActiveTool()).jointPressed(poly, loc, i);
					return true;
				case POLYGON:
					toolKit.setActiveTool(PolygonTool.class);
					((PolygonTool)toolKit.getActiveTool()).jointPressed(poly, loc, i);
					return true;
				}
			}
		}
		return false;
	}

	public abstract void jointPressed(PolygonArea poly, Location location, int jointNumber);
}
