package cz.cuni.amis.pogamut.edu.map.editor.visual;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

import cz.cuni.amis.pogamut.edu.map.editor.visual.tools.AddToLockedTool;
import cz.cuni.amis.pogamut.edu.map.editor.visual.tools.CircleTool;
import cz.cuni.amis.pogamut.edu.map.editor.visual.tools.EditTool;
import cz.cuni.amis.pogamut.edu.map.editor.visual.tools.EditPlanTool;
import cz.cuni.amis.pogamut.edu.map.editor.visual.tools.ExcludeTool;
import cz.cuni.amis.pogamut.edu.map.editor.visual.tools.LockTool;
import cz.cuni.amis.pogamut.edu.map.editor.visual.tools.GoToSuperiorTool;
import cz.cuni.amis.pogamut.edu.map.editor.visual.tools.POITool;
import cz.cuni.amis.pogamut.edu.map.editor.visual.tools.PathTool;
import cz.cuni.amis.pogamut.edu.map.editor.visual.tools.PolygonTool;
import cz.cuni.amis.pogamut.edu.map.editor.visual.tools.RectTool;
import cz.cuni.amis.pogamut.edu.map.editor.visual.tools.RemoveFromLockedTool;
import cz.cuni.amis.pogamut.edu.map.editor.visual.tools.SelectTool;
import cz.cuni.amis.pogamut.edu.map.editor.visual.tools.Tool;
import cz.cuni.amis.pogamut.edu.map.editor.visual.tools.ZoomInTool;
import cz.cuni.amis.pogamut.edu.map.editor.visual.tools.ZoomOutTool;

public class ToolKit extends CompositeHolder {

	protected ZoomInTool zoomIn;
	protected ZoomOutTool zoomOut;
	protected ToolItem separator1;
	protected RectTool rectTool;
	protected CircleTool circleTool;
	protected PolygonTool polyTool;
	protected POITool poiTool;
	protected PathTool pathTool;
	protected SelectTool selectTool;
	protected ToolItem separator2;
	protected LockTool lockTool;
	protected AddToLockedTool addToAbstract;
	protected RemoveFromLockedTool removeFromAbstract;
	protected ExcludeTool excludeTool;
	protected GoToSuperiorTool moreAbstract;
	protected EditTool edit;
	protected ToolItem separator3;
	protected EditPlanTool editPlan;

	protected ToolBar toolBar;
	protected VisualEditor editor;
	protected Tool activeTool;

	public ToolKit(Composite parent, VisualEditor editor) {
		this.editor = editor;
		toolBar = new ToolBar(parent, SWT.VERTICAL);
		zoomIn = new ZoomInTool(this);
		zoomOut = new ZoomOutTool(this);
		separator1 = new ToolItem(toolBar, SWT.SEPARATOR);
		rectTool = new RectTool(this);
		circleTool = new CircleTool(this);
		polyTool = new PolygonTool(this);
		poiTool = new POITool(this);
		pathTool = new PathTool(this);
		selectTool = new SelectTool(this);
		separator2 = new ToolItem(toolBar, SWT.SEPARATOR);
		lockTool = new LockTool(this);
		addToAbstract = new AddToLockedTool(this);
		removeFromAbstract = new RemoveFromLockedTool(this);
		excludeTool = new ExcludeTool(this);
		moreAbstract = new GoToSuperiorTool(this);
		edit = new EditTool(this);
		separator3 = new ToolItem(toolBar, SWT.SEPARATOR);
		editPlan = new EditPlanTool(this);
		toolBar.pack();
	}

	@Override
	public Composite getComposite() {
		return toolBar;
	}

	public VisualEditor getEditor() {
		return editor;
	}

	public Tool getActiveTool() {
		return activeTool;
	}

	public void setActiveTool(Tool activeTool) {
		if (this.activeTool != null) {
			this.activeTool.getToolItem().setSelection(false);
		}
		this.activeTool = activeTool;
		activeTool.getToolItem().setSelection(true);
	}

	public void setActiveTool(Class<?> cls) {
		if (cls == CircleTool.class) {
			setActiveTool(circleTool);
		} else if (cls == RectTool.class) {
			setActiveTool(rectTool);
		} else if (cls == PolygonTool.class) {
			setActiveTool(polyTool);
		} else if (cls == SelectTool.class) {
			setActiveTool(selectTool);
		} else if (cls == POITool.class) {
			setActiveTool(poiTool);
		} else if (cls == PathTool.class) {
			setActiveTool(pathTool);
		} else {
			throw new IllegalArgumentException();
		}
	}

}
