package loquebot.util;

import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.Client.RcvMsgEvent;

import cz.cuni.pogamut.MessageObjects.MessageObject;

/**
 * Abtract class designed for listening to messages from engine.
 *
 * @author Juraj Simlovic [jsimlo@matfyz.cz]
 * @version Tested on Pogamut 2 platform version 1.0.5.
 */
public abstract class LoqueListener implements RcvMsgListener
{
    /**
     * Message switch.
     * @param msg Message to handle.
     */
    protected abstract void processMessage (MessageObject msg);

    /**
     * Event listener.
     * @param e Event to handle.
     */
    public void receiveMessage (RcvMsgEvent e)
    {
        try {
            processMessage(e.getMessage ());
        }
        catch (NumberFormatException ex) {}
    }
}