/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package loquebot.learn;

import cz.cuni.pogamut.MessageObjects.ItemType;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.Iterator;

import loquebot.util.LoqueWeaponInfo;

/**
 *
 * @author Michal Stolba
 */
public class WeaponTable {
    
    //"ImpactHammer", "Enforcer", "Translocator", "GESBioRifle", "ShockRifle", "PulseGun", "Minigun2", "UT_FlakCannon", "UT_Eightball", "WarheadLauncher"
    
    
    private java.util.AbstractMap<ItemType,java.util.AbstractList<Record>> weapons;
    private java.util.AbstractMap<ItemType,Integer> usage;  //how many records for each weapon
    private java.util.AbstractMap<ItemType,WeaponStat> stats;
    
    private String folder;
    
   
    
    public ItemType getLeastUsed(ItemType[] chooseFrom){
        int minUsage = Integer.MAX_VALUE;
        ItemType chosenType = null;
        
        for(ItemType type:chooseFrom){
            if(type!=null){
                int u = usage.containsKey(type) ? usage.get(type) : 0;
                if(u < minUsage){
                    minUsage = u;
                    chosenType = type;
                }
            }
        }
        
        return chosenType;
    }
    
    
    public void addRecord(String weapon, Record record){
        ItemType type = null;
        
        if(weapon.equals("XWeapons.ShieldGun")) type = ItemType.SHIELD_GUN;
        if(weapon.equals("XWeapons.AssaultRifle")) type = ItemType.ASSAULT_RIFLE;
        if(weapon.equals("XWeapons.BioRifle")) type = ItemType.BIO_RIFLE;
        if(weapon.equals("XWeapons.ShockRifle")) type = ItemType.SHOCK_RIFLE;
        if(weapon.equals("XWeapons.LinkGun")) type = ItemType.LINK_GUN;
        if(weapon.equals("XWeapons.Minigun")) type = ItemType.MINIGUN;
        if(weapon.equals("XWeapons.FlakCannon")) type = ItemType.FLAK_CANNON;
        if(weapon.equals("XWeapons.RocketLauncher")) type = ItemType.ROCKET_LAUNCHER;
        if(weapon.equals("XWeapons.SniperRifle")) type = ItemType.SNIPER_RIFLE;
        if(weapon.equals("XWeapons.Redeemer")) type = ItemType.REDEEMER;
        
        if(type == null) return;
        
        //add record
        if(weapons.containsKey(type)){
            weapons.get(type).add(record);
        }else{
            weapons.put(type, new java.util.LinkedList<Record>());
        }
        
        //increase usage counter
        if(usage.containsKey(type)){
            int used = (int)usage.get(type);
            usage.put(type, ++used);
        }else{
            usage.put(type, 0);
        }
    }
    
    public void saveRecords(int episode){
        String filename = "";
        
        Iterator<AbstractList<Record>> it = weapons.values().iterator();
        Iterator<ItemType> itit = weapons.keySet().iterator();
        AbstractList<Record> records;
        java.util.ListIterator<Record> lit;
        Record rec;
        
        while(it.hasNext()){
            records = it.next();
            lit = records.listIterator();
            
            filename = folder + itit.next().toString() + episode +  ".txt";
            
            try {
              PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(filename)));

              while(lit.hasNext()){
                  rec = lit.next();
                  out.println(rec.toString());
              }
              
              out.close();
            } catch(java.io.EOFException e) {
              System.err.println("End of stream");
            }catch (java.io.IOException ex) {
                ex.printStackTrace();
            }
            
        }
        
        
    }
    
    
    public void processRecords(){
    	
        ItemType[] itemTypes = ItemType.values();
        AbstractList<Record> recordsList;
        WeaponStat stat;
        
        
        Record[] records;
        
        
        
        for(ItemType type : itemTypes){ //through all item types
            
            //helper
            boolean wall;
            double distance;
            boolean first;
            boolean priEfDistKnown = false;
            boolean altEfDistKnown = false;

            //aggregation
            double sumPriDamage = 0;
            double sumPriSelfDamage = 0;
            double sumPriWeightedDistance = 0;
            double sumPriSplashRadius = 0;
            double sumAltDamage = 0;
            double sumAltSelfDamage = 0;
            double sumAltWeightedDistance = 0;
            double sumAltSplashRadius = 0;

            int totalPriHits = 0;
            int totalAltHits = 0;

            int numOfPriHits = 0;
            int numOfAltHits = 0;
            int numOfPriSelfHits = 0;
            int numOfAltSelfHits = 0;
            
            //weapon stat
            stat = new WeaponStat(type.toString());
            //get and check records
            recordsList = weapons.get(type);
            if(recordsList == null)continue;
            
            
            //process records for this weapon
            records = recordsList.toArray(new Record[0]);
            for(int i=1; i<records.length; ++i){
               
                if(records[i].damage == 0 && records[i].selfDamage == 0)continue;    //no damage, no interest
                
                //prepare info
                distance = 0;
                first = !(records[i].time == records[i-1].time + 1);    //this is first record from a batch
                if(first){
                    wall = (records[i].distance == -1) ? true : false;   //probably hit some wall
                    if(!wall)distance = records[i].distance;              //more approximate distance
                }else{
                    wall = (records[i].distance == -1 || records[i-1].distance == -1) ? true : false;   //probably hit some wall
                    if(!wall)distance = (records[i].distance + records[i-1].distance) / 2;              //more approximate distance
                }
                
                
                
                
                if(records[i].altFiring){   //concerning alt mode
                    
                    //altDamage
                    if(records[i].damage > 0){
                        sumAltDamage += records[i].damage;
                        ++numOfAltHits;
                    }
                    
                    //effective distance
                    if(records[i].damage > LoqueWeaponInfo.minorTreshold && distance > stat.altEffectiveDistance){
                        stat.altEffectiveDistance = distance;
                        altEfDistKnown = true;
                    }
                    
                    //ideal combat range
                    sumAltWeightedDistance += records[i].damage * distance;
                    totalAltHits += records[i].damage;
                    
                    //max range
                    if(distance > stat.altMaxRange) stat.altMaxRange = distance;
                    
                    //self damage, splash radius
                    if(records[i].selfDamage > 0){
                        sumAltSelfDamage += records[i].selfDamage;
                        sumAltSplashRadius += distance;
                        ++numOfAltSelfHits;
                    }
                    
                    
                    
                }else{  //concerning pri mode
                    
                    
                    
                    
                    
                    //priDamage
                    if(records[i].damage > 0){
                        sumPriDamage += records[i].damage;
                        ++numOfPriHits;
                    }
                    
                    //effective distance
                    if(records[i].damage > LoqueWeaponInfo.minorTreshold && distance > stat.priEffectiveDistance){
                        stat.priEffectiveDistance = distance;
                        priEfDistKnown = true;
                    }
                    
                    //ideal combat range
                    sumPriWeightedDistance += records[i].damage * distance;
                    totalPriHits += records[i].damage;
                    
                    //max range
                    if(distance > stat.priMaxRange) stat.priMaxRange = distance;
                    
                    //self damage, splash radius
                    if(records[i].selfDamage > 0){
                        sumPriSelfDamage += records[i].selfDamage;
                        sumPriSplashRadius += distance;
                        ++numOfPriSelfHits;
                    }
                    
                }
                
            }
            
            //process statistics
            
            if(numOfAltHits >= 3)stat.altDamage = (int)Math.round(sumAltDamage/numOfAltHits);
            stat.altIdealCombatRange  = (int)Math.round(sumAltWeightedDistance/totalAltHits);
            if(numOfAltSelfHits >= 3)stat.altSelfDamage = (int)Math.round(sumAltSelfDamage/numOfAltSelfHits);
            stat.altSplashRadius = (int)Math.round(sumAltSplashRadius/numOfAltSelfHits);
            if(!altEfDistKnown) stat.altEffectiveDistance = 2000;
            
            if(numOfPriHits >= 3)stat.priDamage = (int)Math.round(sumPriDamage/numOfPriHits);
            stat.priIdealCombatRange  = (int)Math.round(sumPriWeightedDistance/totalPriHits);
            if(numOfPriSelfHits >= 3)stat.priSelfDamage = (int)Math.round(sumPriSelfDamage/numOfPriSelfHits);
            stat.priSplashRadius = (int)Math.round(sumPriSplashRadius/numOfPriSelfHits);
            if(!priEfDistKnown) stat.priEffectiveDistance = 2000;
            
            //conclude conclusions
            stat.minorWeapon = (stat.priDamage < LoqueWeaponInfo.minorTreshold && stat.altDamage < LoqueWeaponInfo.minorTreshold) || (stat.priSelfDamage > 50 && stat.altSelfDamage > 50);
            
            //save result
            stats.put(type, stat);
        }
        
    }
    
    
    public void saveStats(int episode){
        String filename = folder + "weapon_info" + episode + ".txt";
        WeaponStat stat;
        
        try {
              PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(filename)));

              for(ItemType type : ItemType.values()){
            	  stat = stats.get(type);
            	  if(stat != null){
            		  out.println(stat.toString());
            	  }
              }
              
              File f = new File(folder + "testfile");
              System.out.println(f.getAbsolutePath());
              f = new File("testfile2");
              System.out.println(f.getAbsolutePath());
              
              out.close();
            } catch(java.io.EOFException e) {
              System.err.println("End of stream");
            }catch (java.io.IOException ex) {
                ex.printStackTrace();
            }
    }
    
    
    public WeaponTable(String outputFolder){
        weapons = new java.util.HashMap<ItemType,java.util.AbstractList<Record>>();
        usage = new java.util.HashMap<ItemType,Integer>();
        stats = new java.util.HashMap<ItemType,WeaponStat>();
        
        folder = outputFolder;
        
//        weapons.put(ItemType.SHIELD_GUN, new java.util.LinkedList<Record>());
//        weapons.put(ItemType.ASSAULT_RIFLE, new java.util.LinkedList<Record>());
//        weapons.put(ItemType.BIO_RIFLE, new java.util.LinkedList<Record>());
//        weapons.put(ItemType.SHOCK_RIFLE, new java.util.LinkedList<Record>());
//        weapons.put(ItemType.LINK_GUN, new java.util.LinkedList<Record>());
//        weapons.put(ItemType.MINIGUN, new java.util.LinkedList<Record>());
//        weapons.put(ItemType.FLAK_CANNON, new java.util.LinkedList<Record>());
//        weapons.put(ItemType.ROCKET_LAUNCHER, new java.util.LinkedList<Record>());
//        weapons.put(ItemType.SNIPER_RIFLE, new java.util.LinkedList<Record>());
//        weapons.put(ItemType.REDEEMER, new java.util.LinkedList<Record>());
//        
    }

}
