package loquebot.learn;

import java.util.StringTokenizer;

import loquebot.util.LoqueWeaponInfo;

public class WeaponStat {

    public String name = "?";
	
	  /**
     * Whether this weapon is a minor one. Should the bot be fighting with this
     * weapon, it should try to pick something better ASAP.
     */
    public boolean minorWeapon = true;
    
    
    
    
    
    public int priDamage = 0;
    public int priSelfDamage = 0;
    /**
     * Max distance to which the weapon can shoot with primary fire mode.
     * Defaults to 9e+9, when there is no range limit.
     */
    public double priMaxRange = 0;
    /**
     * Splash damage radius of primary fire mode. Zero if no splash damage.
     */
    public double priSplashRadius = 0;

    /**
     * Most effective distance from the enemy while using primary fire mode.
     * This value is used to keep desired and working distance from enemies.
     */
    public double priIdealCombatRange = 0;
    
    /**
     * Effective distance of primary fire mode. Beyond this distance, the
     * weapon might start to loose some glance. This value is used as cut-off
     * point for aim-ahead predictions based on enemy distance.
     */
    public double priEffectiveDistance = 0;
    

    
    
    
    
    public int altDamage = 0;
    public int altSelfDamage = 0;
    /**
     * Max distance to which the weapon can shoot with alternate fire mode.
     * Defaults to 9e+9, when there is no range limit.
     */
    public double altMaxRange = 0;
    /**
     * Splash damage radius of alternate fire mode. Zero if no splash damage.
     */
    public double altSplashRadius = 0;
    
    /**
     * Most effective distance from the enemy while using primary fire mode.
     * This value is used to keep desired and working distance from enemies.
     */
    public double altIdealCombatRange = 0;
    
    /**
     * Effective distance of alternate fire mode. Beyond this distance, the
     * weapon might start to loose some glance. This value is used as cut-off
     * point for aim-ahead predictions based on enemy distance.
     */
    public double altEffectiveDistance = 0;
    
    
    

	
    public WeaponStat(String weaponName){
    	name = weaponName;
    }
    
    public String toString(){
    	
    	LoqueWeaponInfo.TEMP.readWeaponStat(this);
    	
    	return this.name + ":\t\t\t alt damage;" + this.altDamage + 
                ";\t alt ef.distance;" + this.altEffectiveDistance + 
                ";\t alt ideal distance;" + this.altIdealCombatRange + 
                ";\t alt max range;" + this.altMaxRange + 
                ";\t alt self damage;" + this.altSelfDamage + 
                ";\t alt splash radius;" + this.altSplashRadius + 
                ";\t minor;" + this.minorWeapon + 
                ";\t pri damage;" + this.priDamage + 
                ";\t pri ef.distance;" + this.priEffectiveDistance + 
                ";\t pri ideal distance;" + this.priIdealCombatRange + 
                ";\t pri max range;" + this.priMaxRange + 
                ";\t pri self damage;" + this.priSelfDamage + 
                ";\t pri splash radius;" + this.priSplashRadius +
                
                ";\t\t alt(250): " + LoqueWeaponInfo.TEMP.altFire(250) +
                ";\t\t alt(500): " + LoqueWeaponInfo.TEMP.altFire(500) +
    			";\t\t general score: " + LoqueWeaponInfo.TEMP.generalScore(3) +
    			//"\t\t inventory score: " + LoqueWeaponInfo.TEMP.inventoryScore(3, 1) +
    			"\t\t combat score(250): " + LoqueWeaponInfo.TEMP.combatScore(3, 250) +
    			"\t\t combat score(500): " + LoqueWeaponInfo.TEMP.combatScore(3, 500);
    
//    	return this.name + ":" + this.altDamage + 
//                ";" + this.altEffectiveDistance + 
//                ";" + this.altIdealCombatRange + 
//                ";" + this.altMaxRange + 
//                ";" + this.altSelfDamage + 
//                ";" + this.altSplashRadius + 
//                ";" + this.minorWeapon + 
//                ";" + this.priDamage + 
//                ";" + this.priEffectiveDistance + 
//                ";" + this.priIdealCombatRange + 
//                ";" + this.priMaxRange + 
//                ";" + this.priSelfDamage + 
//                ";" + this.priSplashRadius;
        }
    
    public static WeaponStat valueOf(String stats){
    	StringTokenizer st = new StringTokenizer(stats,":");
    	WeaponStat ws = new WeaponStat(st.nextToken());
    	
    	st = new StringTokenizer(st.nextToken(),";");
    	
    	//parse rest
        st.nextToken();
        ws.altDamage = Integer.valueOf(st.nextToken());st.nextToken();
    	ws.altEffectiveDistance = Double.valueOf(st.nextToken());st.nextToken();
    	ws.altIdealCombatRange = Double.valueOf(st.nextToken());st.nextToken();
        ws.altMaxRange = Double.valueOf(st.nextToken());st.nextToken();
        ws.altSelfDamage = Integer.valueOf(st.nextToken());st.nextToken();
        ws.altSplashRadius = Double.valueOf(st.nextToken());st.nextToken();
        ws.minorWeapon = Boolean.valueOf(st.nextToken());st.nextToken();
        ws.priDamage = Integer.valueOf(st.nextToken());st.nextToken();
        ws.priEffectiveDistance = Double.valueOf(st.nextToken());st.nextToken();
        ws.priIdealCombatRange = Double.valueOf(st.nextToken());st.nextToken();
        ws.priMaxRange = Double.valueOf(st.nextToken());st.nextToken();
        ws.priSelfDamage = Integer.valueOf(st.nextToken());st.nextToken();
        ws.priSplashRadius = Double.valueOf(st.nextToken());
    	
    	return ws;
    	
    }
	
}
