/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package loquebot.learn;

import cz.cuni.pogamut.Client.AgentBody;
import cz.cuni.pogamut.MessageObjects.AddWeapon;
import cz.cuni.pogamut.MessageObjects.BotDamaged;
import cz.cuni.pogamut.MessageObjects.ChangedWeapon;
import cz.cuni.pogamut.MessageObjects.HearNoise;
import cz.cuni.pogamut.MessageObjects.ItemType;
import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.PlayerDamaged;
import cz.cuni.pogamut.MessageObjects.Self;
import cz.cuni.pogamut.MessageObjects.Triple;
import java.util.logging.Logger;
import loquebot.Main;
import loquebot.memory.LoqueMemory;
import loquebot.util.LoqueListener;

/**
 *
 * @author Michal Stolba
 */
public class LoqueLearnWeapons {
    
    private WeaponTable weaponTab;
    
    private Record currentRecord;
    
    
    //"ImpactHammer", "Enforcer", "Translocator", "GESBioRifle", "ShockRifle", "PulseGun", "Minigun2", "UT_FlakCannon", "UT_Eightball", "WarheadLauncher"
    private String curWeapon;
    
     /*========================================================================*/
    
    
    /**
     * Listening class for messages from engine.
     */
    private class Listener extends LoqueListener
    {

        private void msgBotDamaged(BotDamaged msg) {
            //if(msg.idInstigator == memory.self.getID()){   
                currentRecord.selfDamage += msg.damage;
                currentRecord.selfDamageType = msg.damageType;
            //}
        }

        private void msgChangedWeapon(ChangedWeapon msg) {
            refresh(currentRecord.time);
            curWeapon = msg.cls;
        }

        private void msgHearNoise(HearNoise msg) {
            currentRecord.noise = true;
        }

        private void msgPlayer(Player msg) {
            int d = (int)memory.self.getSpaceDistance(msg.location);
            if(currentRecord.distance >= 0){
                currentRecord.distance = (currentRecord.distance + d)/2;
            } else{
                currentRecord.distance = d;
            }
        }

        private void msgPlayerDamaged(PlayerDamaged msg) {
            if(msg.hitID != memory.self.getID()){
                currentRecord.damage += msg.damage;
                currentRecord.damageType = msg.damageType;
            }
        }
        
        private void msgSelf(Self msg) {
            if(msg.altFiring != 0) currentRecord.altFiring = true;
            
            currentRecord.ammo = msg.currentAmmo;
            currentRecord.altAmmo = msg.currentAltAmmo;
            
//            if(!curWeapon.equals(msg.weapon)){
//                curWeapon = msg.weapon;
//                refresh();
//            }
            
        }
        
        /**
         * Message switch.
         * @param msg Message to handle.
         */
        protected void processMessage (MessageObject msg)
        {
            switch (msg.type)
            {
                case SELF:
                    msgSelf ((Self) msg);
                    return;
                case PLAYER:
                    msgPlayer ((Player) msg);
                    return;
                case PLAYER_DAMAGED:
                    msgPlayerDamaged ((PlayerDamaged) msg);
                    return;
                case CHANGED_WEAPON:
                    msgChangedWeapon ((ChangedWeapon) msg);
                    return;
                case BOT_DAMAGED:
                    msgBotDamaged ((BotDamaged) msg);
                    return;
                case HEAR_NOISE:
                    msgHearNoise ((HearNoise) msg);
                    return;
            }
        }

        /**
         * Constructor: Signs up for listening.
         */
        private Listener ()
        {
            body.addTypedRcvMsgListener (this, MessageType.SELF);
            body.addTypedRcvMsgListener (this, MessageType.PLAYER);
            body.addTypedRcvMsgListener (this, MessageType.PLAYER_DAMAGED);
            body.addTypedRcvMsgListener (this, MessageType.CHANGED_WEAPON);
            body.addTypedRcvMsgListener (this, MessageType.BOT_DAMAGED);
            body.addTypedRcvMsgListener (this, MessageType.HEAR_NOISE);
        }

        
    }

    /** Listener. */
    private LoqueListener listener;

    /*========================================================================*/

    /** Agent's main. */
    protected Main main;
//    /** Loque memory. */
//    protected LoqueMemory memory;
    /** Agent's body. */
    protected AgentBody body;
    protected LoqueMemory memory;
    /** Agent's log. */
    protected Logger log;

    /*========================================================================*/
    
    public void startShoot(boolean alt){
        currentRecord.startShoot = true;
        currentRecord.altFiring = alt;
    }
    
    public void stopShoot(){
        currentRecord.stopShoot = true;
    }
    
    public void refresh(int time){
        weaponTab.addRecord(curWeapon,currentRecord);
        
        currentRecord = new Record();
        currentRecord.ammo = memory.self.getCurrentAmmo();
        currentRecord.ammo = memory.self.getCurrentAltAmmo();
        currentRecord.time = time;
    }
    
    
    
    
    public void processResults(int episode){
        weaponTab.saveRecords(episode);
        weaponTab.processRecords();
        weaponTab.saveStats(episode);
    }
    
    public AddWeapon chooseWeapon(java.util.ArrayList<AddWeapon> weapons){
        ItemType selectedType;
        ItemType types[] = new ItemType[weapons.size()];
        
        int i = 0;
        for(AddWeapon aw:weapons){
            if(aw.currentAmmo > 1 || aw.currentAltAmmo > 1){
                types[i] = aw.getWeaponType();
            }else{
                types[i] = null;
            }
            ++i;
        }
        
        selectedType = weaponTab.getLeastUsed(types);
        
        
        for(AddWeapon aw:weapons){
            if(aw.getWeaponType().equals(selectedType)){
                return aw;
            }
        }
        
        return null;
    }
    
    
    public LoqueLearnWeapons(Main main, LoqueMemory _memory, String folder){
        
        // setup reference to agent
        this.main = main;
        this.body = main.getBody ();
        this.log = main.getLogger ();

        // create listener
        this.listener = new Listener ();
        
        //get needed info from the memory
        memory = _memory;
        curWeapon = "XWeapons.AssalutRifle";
        
        //init objects for recording
        weaponTab = new WeaponTable(folder);
        currentRecord = new Record();
        
    }

}
