package loquebot.drives;

import java.util.ArrayList;

import cz.cuni.pogamut.MessageObjects.Item;

import loquebot.Main;
import loquebot.memory.LoqueMemory;

/**
 * Necessary support for handling searching drive. This class implements all
 * composite methods and decission making routines used by the logic in
 * {@link LoqueWander} to make {@link LoqueWander} look more simple and
 * understandalbe on laic glance.
 *
 * @author Juraj Simlovic [jsimlo@matfyz.cz]
 * @version Tested on Pogamut 2 platform version 1.0.5.
 */
public abstract class LoqueWanderBase extends LoqueDrive
{
    /**
     * Retreives list of useful available power-up items.
     *
     * @return List of the chosen pickups.
     */
    protected ArrayList<Item> getListOfGoodPowerup ()
    {
        ArrayList<Item> items = new ArrayList<Item> (50);

        // add useful health, armor and udamage pickups
        items.addAll (memory.items.getAllHealths (true, false));
        items.addAll (memory.items.getAllArmors (true, false));
        items.addAll (memory.items.getAllSpecials (true, false));

        return items;
    }

    /*========================================================================*/

    /**
     * Retreives list of all pickups filtered by agent inventory/status.
     *
     * @param greedy Whether to forage items we do not really need.
     * @return List of the chosen pickups.
     */
    protected ArrayList<Item> getListOfGoodItems (boolean greedy)
    {
        // get list of the wanted known weapons
        return memory.items.getAllItems(true, greedy);
    }

    /*========================================================================*/

    /**
     * Constructor.
     * @param main Agent's main.
     * @param memory Loque memory.
     */
    public LoqueWanderBase (Main main, LoqueMemory memory)
    {
        super (main, memory);
    }
}