package loquebot.drives;

import java.util.logging.Logger;

import cz.cuni.pogamut.Client.AgentBody;

import loquebot.Main;
import loquebot.memory.LoqueMemory;

/**
 * Abstract parent for all agent drives. Provides access to base agent objects
 * (agent, body, memory, log) as well as some common routines.
 *
 * @author Juraj Simlovic [jsimlo@matfyz.cz]
 * @version Tested on Pogamut 2 platform version 1.0.5.
 */
public abstract class LoqueDrive
{
    /*========================================================================*/

    /** Null log. */
    private Logger nullLog = Logger.getLogger("null");

    /**
     * Enables or disables logging for descending drive.
     * @param enable Whether to enable, or to disable logging.
     */
    protected void enableLogs (boolean enable)
    {
        log = enable ? agentLog : nullLog;
    }

    /*========================================================================*/

    /**
     * Placeholder for any drive logic of the extending agent's drive.
     * @return True, if the drive decided and took action. False otherwise.
     */
    public abstract boolean doLogic ();

    /*========================================================================*/

    /** Agent's main. */
    protected Main main;
    /** Loque memory. */
    protected LoqueMemory memory;
    /** Agent's body. */
    protected AgentBody body;
    /** Agent's log. */
    protected Logger log;
    /** Agent's original log. */
    private Logger agentLog;

    /*========================================================================*/

    /**
     * Constructor.
     * @param main Agent's main.
     * @param memory Loque memory.
     */
    public LoqueDrive (Main main, LoqueMemory memory)
    {
        // setup reference to agent
        this.main = main;
        this.memory = memory;
        this.body = main.getBody ();
        this.log = this.agentLog = main.getLogger ();
    }
}