package studentsposhguide;

import cz.cuni.amis.pogamut.ut2004.bot.sposh.SposhBotLogic;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.utils.exception.PogamutException;
import java.io.IOException;
import cz.cuni.amis.pogamut.ut2004.utils.SingleUT2004BotRunner;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.sposh.UT2004Behaviour;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;

/**
 * Template for the Sposh Bot.
 */
public class GuideLogic extends SposhBotLogic {

    /**
     * Path to the SPOSH plan in the source, used in {@link SposhLogic#getPlan()}.
     */
    private String SPOSH_PLAN_RESOURCE = "studentsposhguide/GuideSPOSHPlan.lap";

    @Override
    protected UT2004Behaviour createBehaviour() {
        return new GuideBehaviour("GuideBehaviour", getBot());
    }

    @Override
    protected String getPlan() throws IOException {
        return getPlanFromResource(SPOSH_PLAN_RESOURCE);
    }

    @Override
    public Initialize getInitializeCommand() {
        return new Initialize().setName("Guide-SPOSH");
    }

    @Override
    public void botInitialized(GameInfo info, ConfigChange config, InitedMessage init) {
        behaviour.botInitialized(info, config, init);
        // TODO called after the bot was initialized
    }

    @Override
    public void botSpawned(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
        behaviour.botSpawned(gameInfo, config, init, self);
        // bot is spawned for the first time in the environment
        // examine 'self' to examine current bot's location and other stuff
    }

    @Override
    public void botKilled(BotKilled event) {
        behaviour.botKilled(event);
        // bot was killed
    }

    /**
     * Create an {@link ExternalBot} with custom made logic and
     * try to connect to Unreal Server at localhost:3000
     *
     * @param args the command line arguments
     */
    public static void main(String[] args) throws PogamutException {
        new SingleUT2004BotRunner<UT2004Bot>(GuideLogic.class, "Guide-SPOSH").startAgent();
    }
}
