package studentsposhemodoc;

import java.io.IOException;

import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.sposh.SposhBotLogic;
import cz.cuni.amis.pogamut.ut2004.bot.sposh.UT2004Behaviour;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.utils.SingleUT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.logging.Level;

/**
 *
 * @author Jimmy
 */
public class EmoDocLogic extends SposhBotLogic {
    private String SPOSH_PLAN_RESOURCE = "studentsposhemodoc/EmoDocSPOSHPlan.lap";

    @Override
    protected UT2004Behaviour createBehaviour() {
        return new EmoDocBehaviour("EmoDocBehaviour", getBot());
    }

    @Override
    protected String getPlan() throws IOException {
        return getPlanFromResource(SPOSH_PLAN_RESOURCE);
    }

    @Override
    public Initialize getInitializeCommand() {
    	return new Initialize().setName("EmoDoc-SPOSH");
    }

    @Override
    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
    	behaviour.botInitialized(gameInfo, currentConfig, init);
        bot.getLogger().setLevel(Level.INFO);
    }

    @Override
    public void botSpawned(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init, Self self) {
    	behaviour.botSpawned(gameInfo, currentConfig, init, self);
    }

    @Override
    public void botKilled(BotKilled event) {
    	behaviour.botKilled(event);
    }

    /**
     * Create an {@link ExternalBot} with custom made logic and
     * try to connect to Unreal Server at localhost:3000
     *
     * @param args the command line arguments
     */
    public static void main(String[] args) throws PogamutException {
        new SingleUT2004BotRunner<UT2004Bot>(EmoDocLogic.class, "SPOSH-EmoDoc").startAgent();
    }

}