/*
 * Decompiled with CFR 0.152.
 */
package weaponfinder;

import cz.cuni.amis.pogamut.base.agent.navigation.PathEventType;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weapon;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemPickedUp;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.WeaponDescriptor;
import cz.cuni.amis.pogamut.ut2004.utils.SingleUT2004BotRunner;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.HashMap;

public class WeaponFinder
extends UT2004BotModuleController {
    TabooSet<NavPoint> seenNavs;
    TabooSet<ItemType> tabooWeapons;
    int weaponsFound = 0;
    private int spawnedWeaponsNumber;
    private HashMap<NavPoint, Item> nav2Item = new HashMap();
    private HashMap<Item, NavPoint> item2Nav = new HashMap();
    private Item runningForWeapon = null;

    @Override
    public void prepareBot(UT2004Bot bot) {
        this.seenNavs = new TabooSet(bot);
        this.tabooWeapons = new TabooSet(bot);
        this.pathExecutor.addPathListener(new PathExecutorListener(){

            @Override
            public void onEvent(PathEventType eventType) {
                switch (eventType) {
                    case BOT_STUCKED: {
                        WeaponFinder.this.botStuck();
                        break;
                    }
                    case TARGET_REACHED: {
                        WeaponFinder.this.targetReached();
                    }
                }
            }
        });
    }

    @EventListener(eventClass=ItemPickedUp.class)
    private void itemPickedUp(ItemPickedUp event) {
        if (event.getType().getCategory() == ItemType.Category.WEAPON) {
            this.tabooWeapons.add(event.getType());
        }
    }

    @Override
    public Initialize getInitializeCommand() {
        return new Initialize().setName("WeaponFinder");
    }

    @Override
    public void botSpawned(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init, Self self) {
        this.spawnedWeaponsNumber = this.weaponry.getWeapons().size();
    }

    public NavPoint pickNextNavPoint() {
        return MyCollections.getRandom(this.seenNavs.filter(this.world.getAll(NavPoint.class).values()));
    }

    @Override
    public void logic() throws PogamutException {
        this.user.info("--- Logic iteration ---");
        this.user.info("Visible navpoints: " + this.world.getAllVisible(NavPoint.class).size() + " / " + this.world.getAll(NavPoint.class).size());
        this.user.info("Visible items:     " + this.world.getAllVisible(Item.class).size() + " / " + this.world.getAll(Item.class).size());
        if (this.weaponry.getWeapons().size() - this.spawnedWeaponsNumber >= 3) {
            this.finish();
            return;
        }
        this.user.info("Has weapons:       " + this.weaponry.getWeapons().size());
        this.user.info("Has extra weapons: " + (this.weaponry.getWeapons().size() - this.spawnedWeaponsNumber));
        for (NavPoint nav : this.world.getAllVisible(NavPoint.class).values()) {
            this.seenNavs.add(nav);
        }
        Item weapon = null;
        for (Item item : this.world.getAllVisible(Item.class).values()) {
            if (item.getDescriptor() instanceof WeaponDescriptor && !this.tabooWeapons.isTaboo(item.getType())) {
                weapon = item;
            }
            if (this.item2Nav.containsKey(item)) continue;
            NavPoint nav = DistanceUtils.getNearest(this.world.getAll(NavPoint.class).values(), item);
            if (nav == null) {
                throw new RuntimeException("No nav nearby for the item: " + item);
            }
            this.nav2Item.put(nav, item);
            this.item2Nav.put(item, nav);
            if (!(item.getDescriptor() instanceof WeaponDescriptor) || this.tabooWeapons.isTaboo(item.getType())) continue;
            weapon = item;
        }
        if (weapon != null && this.runningForWeapon == null) {
            this.pathExecutor.stop();
            this.runningForWeapon = weapon;
            if (this.info.getLocation().getDistance(this.runningForWeapon.getLocation()) < 300.0) {
                this.move.moveTo(this.runningForWeapon);
            } else {
                this.pathExecutor.followPath(this.pathPlanner.computePath(this.runningForWeapon));
            }
            return;
        }
        if (!this.pathExecutor.isMoving()) {
            NavPoint next = this.pickNextNavPoint();
            if (next == null) {
                this.seenNavs.clear();
                next = this.pickNextNavPoint();
            }
            this.runningForWeapon = null;
            this.pathExecutor.followPath(this.pathPlanner.computePath(next));
        }
    }

    protected void targetReached() {
        this.pathExecutor.stop();
        this.runningForWeapon = null;
    }

    private void finish() {
        this.bot.stop();
    }

    protected void botStuck() {
        this.pathExecutor.stop();
    }

    @Override
    public void botKilled(BotKilled event) {
    }

    @Override
    public void botShutdown() {
        this.user.info("Found and pickedup extra " + (this.weaponry.getWeapons().size() - this.spawnedWeaponsNumber) + " weapons.");
        for (Weapon w : this.weaponry.getLoadedWeapons().values()) {
            this.user.info("Owns: " + w.getType());
        }
        this.user.info("---== END ==--");
    }

    public static void main(String[] args) throws PogamutException {
        new SingleUT2004BotRunner(WeaponFinder.class, "Main").startAgent();
    }
}

