/*
 * Decompiled with CFR 0.152.
 */
package emohawk;

import cz.cuni.amis.pogamut.base.agent.navigation.PathEventType;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetectors.StupidStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.AddInventory;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Shoot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StopShooting;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AddInventoryMsg;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.utils.MultipleUT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.maps.LazyMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class EmoHawk
extends UT2004BotModuleController {
    public static final String EMOHAWK_NAME = "EmoHawk";
    private TabooSet<NavPoint> tabooNavPoints;
    boolean huntingPlayer = false;
    Player player = null;
    int noStucked = 0;
    boolean botKilled = true;
    int notSeen = 0;
    boolean pickup = true;
    int navsToPlayer = 0;
    int navsToNav = 0;

    @EventListener(eventClass=PlayerKilled.class)
    private void playerKilled(PlayerKilled event) {
        if (this.huntingPlayer) {
            this.user.info("Player killed!!! Running to random navpoint.");
            this.body.getCommunication().sendGlobalTextMessage("Yummy, yummy!");
            this.huntingPlayer = false;
            this.runToRandomNavPoint();
        }
    }

    @EventListener(eventClass=AddInventoryMsg.class)
    private void inventoryAdded(AddInventoryMsg event) {
        if (event.getPickupType() == ItemType.FLAK_CANNON) {
            this.user.info("Rearming to FlakCannon");
            this.weaponry.changeWeapon(ItemType.FLAK_CANNON);
            this.body.getCommunication().sendGlobalTextMessage("I have rather SHARP teeths!");
        }
    }

    @Override
    public void prepareBot(UT2004Bot bot) {
        this.tabooNavPoints = new TabooSet(bot);
    }

    @Override
    public void botInitialized(GameInfo gameInfo, ConfigChange config, InitedMessage init) {
        this.pathExecutor.addStuckDetector(new StupidStuckDetector(this.getWorldView(), 6.0));
        this.pathExecutor.addPathListener(new PathExecutorListener(){

            @Override
            public void onEvent(PathEventType eventType) {
                switch (eventType) {
                    case TARGET_REACHED: {
                        EmoHawk.this.targetReached();
                        break;
                    }
                    case PATH_ELEMENT_REACHED: {
                        EmoHawk.this.nextNavPointReached();
                        break;
                    }
                    case BOT_STUCKED: {
                        EmoHawk.this.botStucked();
                    }
                }
            }
        });
        this.config.setSpeedMultiplier(0.8);
        LazyMap<ItemType, Integer> types = new LazyMap<ItemType, Integer>(){

            @Override
            protected Integer create(ItemType key) {
                return 0;
            }
        };
        LazyMap<ItemType.Category, Set<ItemType>> cats = new LazyMap<ItemType.Category, Set<ItemType>>(){

            @Override
            protected Set<ItemType> create(ItemType.Category key) {
                return new HashSet<ItemType>();
            }
        };
        for (Item item : this.getWorldView().getAll(Item.class).values()) {
            types.put(item.getType(), (Integer)types.get(item.getType()) + 1);
            ((Set)cats.get((Object)item.getType().getCategory())).add(item.getType());
        }
        System.out.println("ITEM TYPES");
        for (ItemType type : types.keySet()) {
            this.user.info(String.valueOf(type.getName()) + " -> " + types.get(type));
        }
        System.out.println("CATEGORIES (UNIQUE ITEM TYPES)");
        for (ItemType.Category cat : cats.keySet()) {
            this.user.info((Object)((Object)cat) + " -> " + ((Set)cats.get((Object)cat)).size());
        }
        System.out.println("INITIALIZATION DONE");
    }

    @Override
    public Initialize getInitializeCommand() {
        return new Initialize().setName(EMOHAWK_NAME);
    }

    public boolean canSeeNonEmohawk() {
        for (Player plr : this.players.getVisiblePlayers().values()) {
            if (plr.getName().equalsIgnoreCase(EMOHAWK_NAME)) continue;
            return true;
        }
        return false;
    }

    public Player getNearestVisibleNonEmohawkPlayer() {
        double distance = Double.MAX_VALUE;
        Player player = null;
        for (Player plr : this.players.getVisiblePlayers().values()) {
            if (plr.getName().equalsIgnoreCase(EMOHAWK_NAME) || !(distance > plr.getLocation().getDistance(this.info.getLocation()))) continue;
            distance = plr.getLocation().getDistance(this.info.getLocation());
            player = plr;
        }
        return player;
    }

    @Override
    public void logic() {
        if (this.botKilled) {
            this.user.info("EmoHawk has been killed - going to new navpoint.");
            this.runToRandomNavPoint();
            this.botKilled = false;
            this.user.info("Getting FlakCannon + Ammo");
            this.config.setAutoPickup(true);
            this.pickup = true;
            this.getAct().act(new AddInventory().setType("XWeapons.FlakCannonPickup"));
            this.getAct().act(new AddInventory().setType("XWeapons.FlakAmmoPickup"));
            return;
        }
        if (this.getWorldView().getSingle(Self.class).getPrimaryAmmo() < 2) {
            this.user.info("Getting more FlakAmmo");
            this.body.getCommunication().sendGlobalTextMessage("I have rather SHARP teeths!");
            this.config.setAutoPickup(true);
            this.pickup = true;
            this.getAct().act(new AddInventory().setType("XWeapons.FlakAmmoPickup"));
            return;
        }
        if (this.pickup) {
            this.config.setAutoPickup(false);
            this.pickup = false;
        }
        if (this.canSeeNonEmohawk()) {
            if (this.huntingPlayer) {
                if (this.player.isVisible()) {
                    this.getLog().severe(String.valueOf(this.player.getName()) + " visible!");
                    this.notSeen = 0;
                    if (this.info.getLocation().getDistance(this.player.getLocation()) < 200.0) {
                        this.getAct().act(new SendMessage().setGlobal(true).setText("BITING!"));
                        this.getLog().severe("Shooting " + this.player.getName() + ".");
                        this.getAct().act(new Move().setFirstLocation(this.player.getLocation()));
                        this.getAct().act(new Shoot().setTarget(this.player.getId()));
                    } else if (this.info.getLocation().getDistance(this.player.getLocation()) < 500.0) {
                        this.getLog().severe("Running to " + this.player.getName() + " directly.");
                        this.pathExecutor.stop();
                        this.getAct().act(new Move().setFirstLocation(this.player.getLocation()));
                    }
                    return;
                }
            } else {
                this.pathExecutor.stop();
                this.player = this.getNearestVisibleNonEmohawkPlayer();
                if (this.player != null) {
                    this.user.info(String.valueOf(this.player.getName()) + " has been JUST spotted - following path to the player.");
                    this.body.getCommunication().sendGlobalTextMessage("CREEEK, I can see you " + this.player.getName() + "!");
                    this.pathExecutor.followPath(this.pathPlanner.computePath(this.player.getLocation()));
                    this.huntingPlayer = true;
                    this.navsToPlayer = 0;
                    return;
                }
            }
        }
        this.getAct().act(new StopShooting());
        if (this.huntingPlayer) {
            ++this.notSeen;
            this.getLog().severe(String.valueOf(this.player.getName()) + " disappeared (" + this.notSeen + "x) ...");
            if (this.notSeen > 20) {
                this.getLog().severe(String.valueOf(this.player.getName()) + " lost... Running to random navpoint.");
                this.notSeen = 0;
                this.pathExecutor.stop();
                this.huntingPlayer = false;
                this.runToRandomNavPoint();
            }
        }
    }

    protected void botStucked() {
        this.user.info("EmoHawk stucked (" + ++this.noStucked + "x times)");
        ++this.noStucked;
        if (this.noStucked > 10) {
            this.getLog().severe("Respawning...");
            this.getAct().act(new Respawn());
        }
        this.runToRandomNavPoint();
    }

    protected void nextNavPointReached() {
        if (this.huntingPlayer) {
            ++this.navsToPlayer;
            if (this.canSeeNonEmohawk() && this.navsToPlayer > 2) {
                this.getLog().severe("Adjusting path to the player");
                this.navsToPlayer = 0;
                this.pathExecutor.followPath(this.pathPlanner.computePath(this.player.getLocation()));
            } else {
                this.user.info("Following path to the " + this.player.getName() + ".");
            }
        } else {
            ++this.navsToNav;
            if (this.navsToNav > 2) {
                if (this.noStucked != 0) {
                    this.user.info("Resetting stucked.");
                }
                this.navsToNav = 0;
                this.noStucked = 0;
            }
        }
    }

    protected void targetReached() {
        this.user.info("Path finished, choosing next random navpoint.");
        this.runToRandomNavPoint();
    }

    protected void runToRandomNavPoint() {
        Collection<NavPoint> navs = this.getWorldView().getAll(NavPoint.class).values();
        Iterator<NavPoint> iter = navs.iterator();
        int rnd = this.random.nextInt(navs.size());
        int i = 1;
        while (i < rnd) {
            iter.next();
            ++i;
        }
        NavPoint nav = iter.next();
        this.pathExecutor.followPath(this.pathPlanner.computePath(nav.getLocation()));
    }

    @Override
    public void botKilled(BotKilled event) {
        super.botKilled(event);
        this.body.getCommunication().sendGlobalTextMessage("AYIIIIII!");
        this.pathExecutor.stop();
        this.noStucked = 0;
        this.huntingPlayer = false;
        this.player = null;
        this.botKilled = true;
        this.notSeen = 0;
        this.navsToNav = 0;
        this.navsToPlayer = 0;
    }

    public static void main(String[] args) throws PogamutException {
        new MultipleUT2004BotRunner(1, EmoHawk.class, EMOHAWK_NAME).startAgent();
    }
}

