/*
 * Decompiled with CFR 0.152.
 */
package emodoc;

import cz.cuni.amis.pogamut.base.agent.navigation.PathEventType;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.WorldObjectAppearedEvent;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weapon;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UTPathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallPathPlanner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetectors.StupidStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemPickedUp;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.utils.SingleUT2004BotRunner;
import cz.cuni.amis.utils.IFilter;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.ArrayList;
import java.util.List;

public class EmoDoc
extends UT2004BotModuleController {
    public static final int ADRENALINE_RESPAWN_TIME = 60;
    public static final int ITEM_RESPAWN_TIME = 20;
    public static final int UPDATE_PATH_TO_PLAYER_AFTER_N_NAVPOINTS_REACHED = 3;
    public static final double SHOOTING_DISTANCE = 500.0;
    TabooSet<NavPoint> seenNavs;
    List<Item> adrenalines = new ArrayList<Item>();
    TabooSet<Item> tabooAdrenalines;
    List<Item> flakCannons = new ArrayList<Item>();
    TabooSet<Item> tabooItems;
    List<Item> flakCannonAmmos = new ArrayList<Item>();
    int updatePathToPlayerCounter = 3;
    Location runningToLocation = null;
    boolean moving = false;
    Item runningToItem = null;
    Player runningToPlayer = null;
    NavPoint runningToNavPoint = null;

    protected void initializePathFinding(UT2004Bot bot) {
        this.pathPlanner = new FloydWarshallPathPlanner(bot);
        this.pathExecutor = new UTPathExecutor(bot);
    }

    @Override
    public void prepareBot(UT2004Bot bot) {
        this.seenNavs = new TabooSet(bot);
        this.tabooAdrenalines = new TabooSet(bot);
        this.tabooItems = new TabooSet(bot);
        this.pathExecutor.addStuckDetector(new StupidStuckDetector(this.world, 3.0));
        this.pathExecutor.addPathListener(new PathExecutorListener(){

            @Override
            public void onEvent(PathEventType eventType) {
                switch (eventType) {
                    case BOT_STUCKED: {
                        EmoDoc.this.pathEventBotStuck();
                        break;
                    }
                    case PATH_ELEMENT_REACHED: {
                        EmoDoc.this.pathEventNavPointReached();
                        break;
                    }
                    case TARGET_REACHED: {
                        EmoDoc.this.pathEventTargetReached();
                    }
                }
            }
        });
    }

    @Override
    public Initialize getInitializeCommand() {
        return new Initialize().setName("EmoDoc");
    }

    @Override
    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
    }

    @Override
    public void botSpawned(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init, Self self) {
    }

    @ObjectClassEventListener(eventClass=WorldObjectFirstEncounteredEvent.class, objectClass=Item.class)
    public void eventItemEncountered(WorldObjectFirstEncounteredEvent<Item> event) {
        if (((Item)event.getObject()).isDropped()) {
            return;
        }
        NavPoint nav = DistanceUtils.getNearest(this.world.getAll(NavPoint.class).values(), (ILocated)event.getObject());
        nav.setItem((Item)event.getObject());
        ((Item)event.getObject()).setNavPoint(nav);
        if (((Item)event.getObject()).getType() == ItemType.ADRENALINE_PACK) {
            this.user.info("Adrenaline encountered: " + ((Item)event.getObject()).getId());
            this.adrenalines.add((Item)event.getObject());
        } else if (((Item)event.getObject()).getType() == ItemType.FLAK_CANNON) {
            this.user.info("Flak cannon encountered: " + ((Item)event.getObject()).getId());
            this.flakCannons.add((Item)event.getObject());
        } else if (((Item)event.getObject()).getType() == ItemType.FLAK_CANNON_AMMO) {
            this.user.info("Ammo encountered: " + ((Item)event.getObject()).getId());
            this.flakCannonAmmos.add((Item)event.getObject());
        }
    }

    @ObjectClassEventListener(eventClass=WorldObjectAppearedEvent.class, objectClass=NavPoint.class)
    public void eventNavPointAppeared(WorldObjectAppearedEvent<NavPoint> event) {
        this.seenNavs.add((NavPoint)event.getObject());
    }

    @EventListener(eventClass=ItemPickedUp.class)
    public void eventItemPickedUp(ItemPickedUp event) {
        if (event.getType() == ItemType.ADRENALINE_PACK) {
            this.user.info("Adrenaline picked up!");
            this.tabooAdrenalines.add(this.getItem(event.getId()), 60.0);
        } else {
            this.tabooItems.add(this.getItem(event.getId()), 20.0);
            if (event.getType() == ItemType.FLAK_CANNON) {
                this.user.info("Flak cannon picked up.");
                this.weaponry.changeWeapon(ItemType.FLAK_CANNON);
            } else if (event.getType() == ItemType.FLAK_CANNON_AMMO) {
                this.user.info("Ammo picked up!");
            }
            Item item = this.world.getAll(Item.class).get(event.getId());
            if (item != null && item.isDropped()) {
                this.tabooItems.add(item);
            }
        }
    }

    @EventListener(eventClass=EndMessage.class)
    public void eventEndMessage(EndMessage event) {
        for (NavPoint nav : this.world.getAllVisible(NavPoint.class).values()) {
            if (nav.getItem() == null || this.world.getAllVisible(Item.class).containsKey(nav.getItem())) continue;
            Item item = nav.getItemInstance();
            if (item == null) {
                return;
            }
            if (this.tabooItems.isTaboo(item) || this.tabooAdrenalines.isTaboo(item)) continue;
            if (item.getType() == ItemType.ADRENALINE_PACK) {
                this.tabooAdrenalines.add(item, 20.0);
                continue;
            }
            this.tabooItems.add(item, 20.0);
        }
    }

    @EventListener(eventClass=PlayerKilled.class)
    public void eventPlayerKilled(PlayerKilled event) {
        this.user.info("EmoHawk killed!");
        this.stopShooting();
    }

    public boolean knowNavPointToExplore() {
        return this.getNavPointToExplore() != null;
    }

    public boolean knowAdrenalineSpawningPoint() {
        return this.adrenalines.size() > 0;
    }

    public boolean knowWeaponSpawningPoint() {
        return this.flakCannons.size() > 0;
    }

    public boolean knowAmmoSpawningPoint() {
        return this.flakCannonAmmos.size() > 0;
    }

    public boolean knowWeaponOrAmmoSpawningPoint() {
        return this.knowWeaponSpawningPoint() || this.knowAmmoSpawningPoint();
    }

    public boolean knowSpawnedWeapon() {
        return this.getNearestSpawnedWeapon() != null;
    }

    public boolean knowSpawnedAdrenaline() {
        return this.getNearestSpawnedAdrenaline() != null;
    }

    public boolean knowSpawnedAmmo() {
        return this.getNearestSpawnedAmmo() != null;
    }

    public boolean knowSpawnedWeaponOrAmmo() {
        return this.knowSpawnedWeapon() || this.knowSpawnedAmmo();
    }

    public boolean canSeeAdrenaline() {
        return this.getNearestVisibleAdrenaline() != null;
    }

    public boolean canSeeWeapon() {
        return this.getNearestVisibleWeapon() != null;
    }

    public boolean canSeeAmmo() {
        return this.getNearestVisibleAmmo() != null;
    }

    public boolean canSeeAmmoOrWeapon() {
        return this.canSeeWeapon() || this.canSeeAmmo();
    }

    public boolean canSeeEnemy() {
        return this.getNearestVisibleEnemy() != null;
    }

    public NavPoint getRandomNavPoint() {
        return MyCollections.getRandom(this.world.getAll(NavPoint.class).values());
    }

    public NavPoint getNearestNavPoint() {
        return this.info.getNearestNavPoint();
    }

    public NavPoint getNavPointToExplore() {
        NavPoint nav = DistanceUtils.getNearest(this.seenNavs.filter(this.world.getAll(NavPoint.class).values()), this.info.getLocation());
        if (nav != null) {
            this.user.info("navpoint to explore: " + nav.getId().getStringId());
            return nav;
        }
        this.user.info("navpoint to explore: NULL");
        return null;
    }

    public NavPoint getNearestVisibleNavPoint() {
        return this.info.getNearestVisibleNavPoint();
    }

    public Item getNearestVisibleAdrenaline() {
        Item item = DistanceUtils.getNearestFiltered(this.world.getAllVisible(Item.class).values(), this.info.getLocation(), new IFilter<Item>(){

            @Override
            public boolean isAccepted(Item object) {
                return object.getType() == ItemType.ADRENALINE_PACK;
            }
        });
        if (item != null) {
            this.user.info("nearest visible adrenaline: " + item.getId().getStringId());
            return item;
        }
        this.user.info("nearest visible adrenaline: NULL");
        return null;
    }

    public Item getNearestVisibleWeapon() {
        Item item = DistanceUtils.getNearestFiltered(this.world.getAllVisible(Item.class).values(), this.info.getLocation(), new IFilter<Item>(){

            @Override
            public boolean isAccepted(Item object) {
                return object.getType().getCategory() == ItemType.Category.WEAPON;
            }
        });
        if (item != null) {
            this.user.info("nearest visible weapon: " + item.getId().getStringId());
            return item;
        }
        this.user.info("nearest visible weapon: NULL");
        return null;
    }

    public Item getNearestVisibleAmmo() {
        Item item = DistanceUtils.getNearestFiltered(this.world.getAllVisible(Item.class).values(), this.info.getLocation(), new IFilter<Item>(){

            @Override
            public boolean isAccepted(Item object) {
                return object.getType().getCategory() == ItemType.Category.AMMO;
            }
        });
        if (item != null) {
            this.user.info("nearest visible ammo: " + item.getId().getStringId());
            return item;
        }
        this.user.info("nearest visible ammo: NULL");
        return null;
    }

    public Item getNearestVisibleAmmoOrWeapon() {
        Item item = DistanceUtils.getNearestFiltered(this.world.getAllVisible(Item.class).values(), this.info.getLocation(), new IFilter<Item>(){

            @Override
            public boolean isAccepted(Item object) {
                return object.getType().getCategory() == ItemType.Category.AMMO || object.getType().getCategory() == ItemType.Category.WEAPON;
            }
        });
        if (item != null) {
            this.user.info("nearest visible weapon or ammo: " + item.getId().getStringId());
            return item;
        }
        this.user.info("nearest visible weapon or ammo: NULL");
        return null;
    }

    public Player getNearestVisibleEnemy() {
        return this.players.getNearestVisibleEnemy();
    }

    public Item getNearestSpawnedAdrenaline() {
        Item item = DistanceUtils.getNearest(this.tabooAdrenalines.filter(this.adrenalines), this.info.getLocation());
        if (item != null) {
            this.user.info("nearest spawned adrenaline: " + item.getId().getStringId());
            return item;
        }
        this.user.info("nearest spawned adrenaline: NULL");
        return null;
    }

    public Item getNearestSpawnedWeapon() {
        Item item = DistanceUtils.getNearestFiltered(this.world.getAll(Item.class).values(), this.info.getLocation(), new IFilter<Item>(){

            @Override
            public boolean isAccepted(Item object) {
                return object.getType().getCategory() == ItemType.Category.WEAPON && !EmoDoc.this.tabooItems.isTaboo(object);
            }
        });
        if (item != null) {
            this.user.info("nearest spawned weapon: " + item.getId().getStringId());
            return item;
        }
        this.user.info("nearest spawned weapon: NULL");
        return null;
    }

    public Item getNearestSpawnedAmmo() {
        Item item = DistanceUtils.getNearestFiltered(this.world.getAll(Item.class).values(), this.info.getLocation(), new IFilter<Item>(){

            @Override
            public boolean isAccepted(Item object) {
                return object.getType().getCategory() == ItemType.Category.AMMO && !EmoDoc.this.tabooItems.isTaboo(object);
            }
        });
        if (item != null) {
            this.user.info("nearest spawned ammo: " + item.getId().getStringId());
            return item;
        }
        this.user.info("nearest spawned ammo: NULL");
        return null;
    }

    public Item getNearestSpawnedWeaponOrAmmo() {
        Item item = DistanceUtils.getNearestFiltered(this.world.getAll(Item.class).values(), this.info.getLocation(), new IFilter<Item>(){

            @Override
            public boolean isAccepted(Item object) {
                return (object.getType().getCategory() == ItemType.Category.AMMO || object.getType().getCategory() == ItemType.Category.WEAPON) && !EmoDoc.this.tabooItems.isTaboo(object);
            }
        });
        if (item != null) {
            this.user.info("nearest spawned weapon or ammo: " + item.getId().getStringId());
            return item;
        }
        this.user.info("nearest spawned weapon or ammo: NULL");
        return null;
    }

    public Item getItem(UnrealId id) {
        return this.world.getAll(Item.class).get(id);
    }

    public Weapon getWeapon() {
        return this.weaponry.getCurrentWeapon();
    }

    public boolean hasWeapon() {
        return this.getWeapon() != null;
    }

    public int getAmmo() {
        return this.weaponry.getAmmo(ItemType.FLAK_CANNON_AMMO);
    }

    public boolean hasAmmo() {
        return this.weaponry.getAmmo(ItemType.FLAK_CANNON_AMMO) > 0;
    }

    public boolean canShoot() {
        return this.hasWeapon() && this.hasAmmo();
    }

    public double getDistanceToNearestVisibleEnemy() {
        Player enemy = this.getNearestVisibleEnemy();
        return enemy == null ? Double.MAX_VALUE : enemy.getLocation().getDistance(this.info.getLocation());
    }

    public boolean isEnemyInShootingDistance() {
        return this.getDistanceToNearestVisibleEnemy() < 500.0;
    }

    public int getAdrenaline() {
        return this.info.getAdrenaline();
    }

    public boolean isShooting() {
        return this.info.isShooting();
    }

    public boolean isMoving() {
        return this.moving;
    }

    public boolean isRunningToItem() {
        return this.isMoving() && this.runningToItem != null;
    }

    public boolean isRunningToPlayer() {
        return this.runningToPlayer != null;
    }

    public boolean isRunningToNavPoint() {
        return this.runningToNavPoint != null;
    }

    public double getDistanceToTarget() {
        if (this.runningToLocation == null) {
            return Double.MAX_VALUE;
        }
        return this.runningToLocation.getDistance(this.info.getLocation());
    }

    public boolean wantToSwitchToItem(Item itemToSwitchTo) {
        if (this.runningToItem == null) {
            return true;
        }
        if (this.runningToItem.getType() == ItemType.FLAK_CANNON) {
            return false;
        }
        return this.runningToItem.getType() == ItemType.FLAK_CANNON_AMMO && itemToSwitchTo.getType() == ItemType.FLAK_CANNON;
    }

    public void pathEventBotStuck() {
        this.stopMovement();
        if (this.runningToItem != null) {
            this.tabooAdrenalines.add(this.runningToItem, 10.0);
            this.tabooItems.add(this.runningToItem, 10.0);
        } else if (this.runningToNavPoint != null) {
            this.seenNavs.add(this.runningToNavPoint, 10.0);
        }
    }

    public void pathEventNavPointReached() {
        if (this.runningToPlayer != null) {
            --this.updatePathToPlayerCounter;
            if (this.updatePathToPlayerCounter <= 0 && this.runningToPlayer.isVisible()) {
                this.runToPlayer(this.runningToPlayer);
            }
        }
    }

    public void pathEventTargetReached() {
        if (this.runningToItem != null) {
            this.move.moveTo(this.runningToItem.getLocation());
        }
        if (this.runningToNavPoint != null) {
            this.seenNavs.add(this.runningToNavPoint);
        }
        this.stopMovement();
    }

    public void stopMovement() {
        this.pathExecutor.stop();
        this.move.stopMovement();
        this.moving = false;
        this.runningToLocation = null;
        this.runningToItem = null;
        this.runningToPlayer = null;
        this.runningToNavPoint = null;
    }

    public void runToItem(Item item) {
        if (this.runningToItem == item) {
            return;
        }
        this.user.info("Running for item: " + item.getId().getStringId());
        this.moving = true;
        this.runningToItem = item;
        this.runningToPlayer = null;
        this.runningToNavPoint = null;
        this.runningToLocation = item.getLocation();
        this.pathExecutor.followPath(this.pathPlanner.computePath(item));
    }

    public void runToNavPoint(NavPoint navPoint) {
        if (this.runningToNavPoint == navPoint) {
            return;
        }
        this.user.info("Running to navpoint: " + navPoint.getId().getStringId());
        this.moving = true;
        this.runningToItem = null;
        this.runningToPlayer = null;
        this.runningToNavPoint = navPoint;
        this.runningToLocation = navPoint.getLocation();
        this.pathExecutor.followPath(this.pathPlanner.computePath(navPoint));
    }

    public void runToPlayer(Player player) {
        if (this.runningToPlayer == player) {
            return;
        }
        this.user.info("Running to player: " + player.getId().getStringId());
        this.moving = true;
        this.runningToItem = null;
        this.runningToPlayer = player;
        this.runningToNavPoint = null;
        this.runningToLocation = player.getLocation();
        this.updatePathToPlayerCounter = 3;
        this.pathExecutor.followPath(this.pathPlanner.computePath(player));
    }

    public void shoot(Player player) {
        if (!this.canShoot()) {
            this.user.warning("CAN NOT SHOOT! But trying nevertheless...");
        } else {
            this.user.info("Shooting at: " + player.getId().getStringId());
        }
        this.shoot.shoot(player);
    }

    public void stopShooting() {
        this.shoot.stopShooting();
    }

    @Override
    public void logic() throws PogamutException {
        this.user.severe("---=== LOGIC ===---");
        this.user.info("Adrenalines:        " + this.info.getAdrenaline());
        this.user.info("Weapon:             " + this.weaponry.getCurrentWeapon());
        this.user.info("Ammo:               " + this.weaponry.getCurrentAmmo());
        this.user.info("Can see enemy:      " + (this.getNearestVisibleEnemy() != null));
        if (this.isRunningToItem()) {
            this.user.info("Running for item:   " + this.runningToItem.getId().getStringId());
        }
        if (this.isRunningToPlayer()) {
            this.user.info("Running to enemy:   " + this.runningToPlayer.getId().getStringId());
        }
        if (this.isRunningToNavPoint()) {
            this.user.info("Running to navpoint: " + this.runningToNavPoint.getId().getStringId());
        }
        if (this.isMoving()) {
            this.user.info("Distance:           " + this.getDistanceToTarget());
        }
        this.user.info("--- ACTION SELECTION---");
        if (this.canShoot() && this.canSeeEnemy()) {
            if (this.isEnemyInShootingDistance()) {
                this.shoot(this.getNearestVisibleEnemy());
                return;
            }
            this.runToPlayer(this.getNearestVisibleEnemy());
        } else if (!this.hasWeapon() && this.canSeeWeapon() && this.wantToSwitchToItem(this.getNearestVisibleWeapon())) {
            this.runToItem(this.getNearestVisibleWeapon());
        } else if (this.getAmmo() < 3 && this.canSeeAmmoOrWeapon() && this.wantToSwitchToItem(this.getNearestVisibleAmmoOrWeapon())) {
            this.runToItem(this.getNearestVisibleAmmoOrWeapon());
        } else if (this.canSeeAdrenaline() && this.wantToSwitchToItem(this.getNearestVisibleAdrenaline())) {
            this.runToItem(this.getNearestVisibleAdrenaline());
        } else if (!this.isMoving()) {
            if (!this.hasWeapon() && this.knowSpawnedWeapon()) {
                this.runToItem(this.getNearestSpawnedWeapon());
            } else if (this.getAmmo() < 3 && this.knowSpawnedWeaponOrAmmo()) {
                this.runToItem(this.getNearestSpawnedWeaponOrAmmo());
            } else if (this.knowSpawnedAdrenaline()) {
                this.runToItem(this.getNearestSpawnedAdrenaline());
            } else if (this.knowNavPointToExplore()) {
                this.runToNavPoint(this.getNavPointToExplore());
            } else {
                this.runToNavPoint(this.getRandomNavPoint());
            }
        }
    }

    @Override
    public void botKilled(BotKilled event) {
        this.stopMovement();
        this.stopShooting();
    }

    public static void main(String[] args) throws PogamutException {
        new SingleUT2004BotRunner(EmoDoc.class, "EmoDoc").startAgent();
    }
}

