/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Pattern;

public class LogFilter {
    private File source;
    private File destination;
    private Pattern[] accept;
    private Pattern[] remove;

    public LogFilter(File source, File destination, Pattern[] accept, Pattern[] remove) {
        this.source = source;
        this.destination = destination;
        this.accept = accept;
        this.remove = remove;
    }

    public void filter() throws IOException {
        FileReader fileReader = new FileReader(this.source);
        try {
            BufferedReader reader = new BufferedReader(fileReader);
            FileWriter fileWriter = new FileWriter(this.destination);
            try {
                PrintWriter writer = new PrintWriter(fileWriter);
                System.out.println("-= Log filtering =-");
                System.out.println("Source: " + this.source.getAbsolutePath());
                System.out.println("Destin: " + this.destination.getAbsolutePath());
                int lineCount = 0;
                while (reader.ready()) {
                    boolean next = false;
                    System.out.print(".");
                    if (++lineCount % 100 == 0) {
                        System.out.println();
                    }
                    String line = reader.readLine();
                    Pattern[] patternArray = this.accept;
                    int n = this.accept.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Pattern a = patternArray[n2];
                        if (a.matcher(line).find()) {
                            writer.println(line);
                            next = true;
                            break;
                        }
                        ++n2;
                    }
                    if (next) continue;
                    patternArray = this.remove;
                    n = this.remove.length;
                    n2 = 0;
                    while (n2 < n) {
                        Pattern r = patternArray[n2];
                        if (r.matcher(line).find()) {
                            next = true;
                            break;
                        }
                        ++n2;
                    }
                    if (next) continue;
                    writer.println(line);
                }
                System.out.println();
                System.out.println("FINISHED");
            }
            finally {
                fileWriter.close();
            }
        }
        finally {
            fileReader.close();
        }
    }
}

