/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.utils;

import cz.cuni.amis.pogamut.base.agent.utils.runner.impl.RemoteAgentRunner;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.factory.IRemoteAgentFactory;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.PogamutPlatform;
import cz.cuni.amis.pogamut.base.utils.PogamutProperty;
import cz.cuni.amis.pogamut.ut2004.observer.IUT2004Observer;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.logging.Level;

public class UT2004ObserverRunner<T extends IUT2004Observer>
extends RemoteAgentRunner<T> {
    protected String host;
    protected int port;

    public UT2004ObserverRunner(IRemoteAgentFactory<SocketConnectionAddress> factory, String name, String host, int port) {
        super(factory, name);
        this.port = port;
        this.host = host;
    }

    public UT2004ObserverRunner(IRemoteAgentFactory<SocketConnectionAddress> factory, String name) {
        super(factory, name);
        PogamutPlatform pl = Pogamut.getPlatform();
        this.host = pl.getProperty(PogamutProperty.POGAMUT_UT2004_SERVER_HOST.getKey());
        this.port = pl.getIntProperty(PogamutProperty.POGAMUT_UT2004_SERVER_PORT.getKey());
    }

    public UT2004ObserverRunner(IRemoteAgentFactory<SocketConnectionAddress> factory) {
        this(factory, "Default UTObserver Factory");
    }

    @Override
    public SocketConnectionAddress getAddress() {
        return new SocketConnectionAddress(this.host, this.port);
    }

    @Override
    protected void preStartHook(T agent) throws PogamutException {
        agent.getLogger().setLevel(Level.SEVERE);
    }
}

