/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.utils;

import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.utils.runner.impl.RemoteAgentRunner;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.PogamutPlatform;
import cz.cuni.amis.pogamut.base.utils.PogamutProperty;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004BotController;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotModule;
import cz.cuni.amis.utils.exception.PogamutException;

public class SingleUT2004BotRunner<T extends UT2004Bot>
extends RemoteAgentRunner<T> {
    protected String host;
    protected int port;

    public SingleUT2004BotRunner(Class<? extends IUT2004BotController> controllerClass, String name, String host, int port) {
        super(new UT2004BotFactory(new UT2004BotModule(controllerClass)), name);
        this.port = port;
        this.host = host;
    }

    public SingleUT2004BotRunner(Class<? extends IUT2004BotController> controllerClass, String name) {
        super(new UT2004BotFactory(new UT2004BotModule(controllerClass)), name);
        PogamutPlatform pl = Pogamut.getPlatform();
        this.host = pl.getProperty(PogamutProperty.POGAMUT_UT2004_BOT_HOST.getKey());
        this.port = pl.getIntProperty(PogamutProperty.POGAMUT_UT2004_BOT_PORT.getKey());
    }

    @Override
    public SocketConnectionAddress getAddress() {
        return new SocketConnectionAddress(this.host, this.port);
    }

    @Override
    public synchronized T startAgent() throws PogamutException {
        UT2004Bot agent = null;
        try {
            this.preInitHook();
            agent = (UT2004Bot)this.factory.newAgent(this.getAgentId(), this.getAddress());
            agent.getLogger().addDefaultConsoleHandler();
            this.preStartHook(agent);
            agent.start();
            try {
                this.postStartHook(agent);
            }
            catch (Exception e1) {
                agent.kill();
                throw new PogamutException("Could not start the agent, postStartHook() failed.", e1, (Object)this);
            }
            agent.awaitState(IAgentStateDown.class);
        }
        finally {
            Pogamut.getPlatform().close();
        }
        return (T)agent;
    }
}

