/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.test;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.state.WaitForAgentStateChange;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.factory.IRemoteAgentFactory;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.PogamutProperty;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.LogPublisher;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004BotController;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotModule;
import cz.cuni.amis.pogamut.ut2004.observer.IUT2004Observer;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.pogamut.ut2004.server.exception.UCCStartException;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004ObserverRunner;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004ServerRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.Flag;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.junit.After;
import org.junit.Before;

public class UT2004Test {
    protected IAgentId testId;
    protected LogCategory log;
    protected UCCWrapper ucc = null;
    protected boolean useInternalUcc = !Pogamut.getPlatform().getBooleanProperty(PogamutProperty.POGAMUT_UNREAL_TEST_EXT_SERVER.getKey());

    public UT2004Test() {
        this.testId = new AgentId("Test");
        this.log = new LogCategory("UT2004Test");
        this.log.addHandler(new LogPublisher.ConsolePublisher(this.testId));
    }

    public void startUCC(UCCWrapper.UCCWrapperConf uccConf) throws UCCStartException {
        if (this.useInternalUcc) {
            this.ucc = new UCCWrapper(uccConf);
        }
    }

    public void endUcc() {
        if (this.useInternalUcc) {
            this.ucc.stop();
        }
    }

    @Before
    public void startTest() throws UCCStartException {
        this.startUCC(new UCCWrapper.UCCWrapperConf());
    }

    @After
    public void endTest() {
        this.endUcc();
        Pogamut.getPlatform().close();
    }

    protected boolean awaitAgentUp(AbstractAgent agent) {
        System.out.println("Awaiting server UP(timeout 60s)...");
        IAgentState state = (IAgentState)new WaitForAgentStateChange((Flag<IAgentState>)agent.getState(), (Class<? extends IAgentState>)IAgentStateUp.class).await(60000L, TimeUnit.MILLISECONDS);
        return state != null && state instanceof IAgentStateUp;
    }

    protected boolean awaitAgentDown(AbstractAgent agent) {
        System.out.println("Awaiting server DOWN (timeout 60s)...");
        IAgentState state = (IAgentState)new WaitForAgentStateChange((Flag<IAgentState>)agent.getState(), (Class<? extends IAgentState>)IAgentStateDown.class).await(120000L, TimeUnit.MILLISECONDS);
        return state != null && state instanceof IAgentStateDown;
    }

    protected <T extends IUT2004BotController> UT2004Bot startUTBot(Class<T> controller) {
        UT2004BotFactory factory = new UT2004BotFactory(new UT2004BotModule(controller));
        String host = Pogamut.getPlatform().getProperty(PogamutProperty.POGAMUT_UT2004_BOT_HOST.getKey());
        int port = Pogamut.getPlatform().getIntProperty(PogamutProperty.POGAMUT_UT2004_BOT_PORT.getKey());
        if (this.useInternalUcc) {
            host = this.ucc.getHost();
            port = this.ucc.getBotPort();
        }
        UT2004BotRunner botRunner = new UT2004BotRunner(factory, "TEST factory", host, port);
        UT2004Bot bot = (UT2004Bot)botRunner.startAgent();
        return bot;
    }

    protected IUT2004Server startUTServer(IRemoteAgentFactory<SocketConnectionAddress> factory) {
        String host = Pogamut.getPlatform().getProperty(PogamutProperty.POGAMUT_UT2004_SERVER_HOST.getKey());
        int port = Pogamut.getPlatform().getIntProperty(PogamutProperty.POGAMUT_UT2004_SERVER_PORT.getKey());
        if (this.useInternalUcc) {
            host = this.ucc.getHost();
            port = this.ucc.getControlPort();
        }
        UT2004ServerRunner runner = new UT2004ServerRunner(factory, "TEST server", host, port){

            @Override
            protected void preStartHook(IUT2004Server agent) throws PogamutException {
                agent.getLogger().setLevel(Level.ALL);
            }
        };
        return (IUT2004Server)runner.startAgent();
    }

    protected IUT2004Observer startUTObserver(IRemoteAgentFactory<SocketConnectionAddress> factory) {
        String host = Pogamut.getPlatform().getProperty(PogamutProperty.POGAMUT_UT2004_SERVER_HOST.getKey());
        int port = Pogamut.getPlatform().getIntProperty(PogamutProperty.POGAMUT_UT2004_SERVER_PORT.getKey());
        if (this.useInternalUcc) {
            host = this.ucc.getHost();
            port = this.ucc.getObserverPort();
        }
        UT2004ObserverRunner runner = new UT2004ObserverRunner(factory, "TEST observer", host, port){

            @Override
            protected void preStartHook(IUT2004Observer agent) throws PogamutException {
                agent.getLogger().setLevel(Level.ALL);
            }
        };
        return (IUT2004Observer)runner.startAgent();
    }
}

