/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples;

import cz.cuni.amis.pogamut.base.agent.navigation.PathEventType;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorListener;
import cz.cuni.amis.pogamut.base.agent.navigation.PathHandle;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetectors.StupidStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.utils.SingleUT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.Collection;

@AgentScoped
public class NavigationBot
extends UT2004BotModuleController {
    @Override
    public Initialize getInitializeCommand() {
        return new Initialize().setName("NavigationBot");
    }

    @Override
    public void botInitialized(GameInfo gameInfo, ConfigChange config, InitedMessage init) {
        this.pathExecutor.addStuckDetector(new StupidStuckDetector(this.getWorldView(), 3.0));
        this.pathExecutor.addPathListener(new PathExecutorListener(){

            @Override
            public void onEvent(PathEventType eventType) {
                switch (eventType) {
                    case TARGET_REACHED: {
                        NavigationBot.this.goToRandomNavPoint();
                        break;
                    }
                    case BOT_STUCKED: {
                        NavPoint target = DistanceUtils.getSecondNearest(NavigationBot.this.getWorldView().getAll(NavPoint.class).values(), NavigationBot.this.bot);
                        NavigationBot.this.pathExecutor.followPath(NavigationBot.this.pathPlanner.computePath(target));
                    }
                }
            }
        });
    }

    @Override
    public void botSpawned(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
        this.goToRandomNavPoint();
    }

    @Override
    public void logic() throws PogamutException {
        this.user.info("--- Logic iteration ---");
        this.user.info("Visible navpoints: " + this.world.getAllVisible(NavPoint.class).size() + " / " + this.world.getAll(NavPoint.class).size());
        this.user.info("Visible items:     " + this.world.getAllVisible(Item.class).size() + " / " + this.world.getAll(Item.class).size());
    }

    @Override
    public void botKilled(BotKilled event) {
        this.pathExecutor.stop();
    }

    protected void goToRandomNavPoint() {
        NavPoint navPoint = this.pickNewRandomNavTarget();
        PathHandle pathHandle = this.pathPlanner.computePath(navPoint);
        this.pathExecutor.followPath(pathHandle);
    }

    private NavPoint pickNewRandomNavTarget() {
        this.getLog().severe("Picking new target navpoint.");
        Collection<NavPoint> navPoints = this.getWorldView().getAll(NavPoint.class).values();
        int navPointIndex = this.random.nextInt(navPoints.size());
        int i = 0;
        for (NavPoint nav : navPoints) {
            if (i == navPointIndex) {
                return nav;
            }
            ++i;
        }
        throw new RuntimeException("No navpoint chosen. There are no navpoints in the list of known navpoints");
    }

    public static void main(String[] args) throws PogamutException {
        new SingleUT2004BotRunner(NavigationBot.class, "NavigationBot").startAgent();
    }
}

