/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples;

import cz.cuni.amis.introspection.java.JProp;
import cz.cuni.amis.pogamut.base.agent.navigation.PathEventType;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weapon;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Rotate;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Shoot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Stop;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StopShooting;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerKilled;
import cz.cuni.amis.pogamut.ut2004.utils.MultipleUT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

@AgentScoped
public class Hunter
extends UT2004BotModuleController<UT2004Bot> {
    @JProp
    public boolean shouldEngage = true;
    @JProp
    public boolean shouldPursue = true;
    @JProp
    public boolean shouldRearm = true;
    @JProp
    public boolean shouldCollectItems = true;
    @JProp
    public boolean shouldCollectHealth = true;
    @JProp
    public int healthLevel = 90;
    @JProp
    public int frags = 0;
    @JProp
    public int deaths = 0;
    Player enemy = null;
    TabooSet<Item> tabooItems = null;
    State previousState = State.OTHER;
    int notMoving = 0;
    private boolean runningToPlayer = false;
    int pursueCount = 0;
    Item item = null;
    List<Item> itemsToRunAround = null;

    @EventListener(eventClass=PlayerKilled.class)
    public void playerKilled(PlayerKilled event) {
        if (this.enemy == null) {
            return;
        }
        if (this.enemy.getId().equals(event.getId())) {
            this.previousState = State.OTHER;
            this.enemy = null;
        }
    }

    @Override
    public void prepareBot(UT2004Bot bot) {
        this.tabooItems = new TabooSet(bot);
        this.pathExecutor.addPathListener(new PathExecutorListener(){

            @Override
            public void onEvent(PathEventType eventType) {
                switch (eventType) {
                    case BOT_STUCKED: {
                        if (Hunter.this.item != null) {
                            Hunter.this.tabooItems.add(Hunter.this.item, 10.0);
                        }
                        Hunter.this.reset();
                        break;
                    }
                    case TARGET_REACHED: {
                        Hunter.this.reset();
                    }
                }
            }
        });
    }

    @Override
    public Initialize getInitializeCommand() {
        return new Initialize().setName("Hunter");
    }

    public void reset() {
        this.previousState = State.OTHER;
        this.notMoving = 0;
        this.enemy = null;
        this.pathExecutor.stop();
        this.itemsToRunAround = null;
        this.item = null;
    }

    @Override
    public void logic() {
        if (!this.info.isMoving().booleanValue()) {
            ++this.notMoving;
            if (this.notMoving > 4) {
                this.reset();
            }
        }
        if (this.shouldEngage && this.players.canSeeEnemies() && this.weaponry.hasLoadedWeapon()) {
            this.stateEngage();
            return;
        }
        if (this.info.isShooting().booleanValue() || this.info.isSecondaryShooting().booleanValue()) {
            this.getAct().act(new StopShooting());
        }
        if (this.senses.isBeingDamaged()) {
            this.stateHit();
            return;
        }
        if (this.enemy != null && this.shouldPursue && this.weaponry.hasLoadedWeapon()) {
            this.statePursue();
            return;
        }
        if (this.info.getHealth() < this.healthLevel && this.canRunAlongMedKit()) {
            this.stateMedKit();
            return;
        }
        if (this.shouldCollectItems && !this.items.getVisibleItems().isEmpty()) {
            this.stateSeeItem();
            this.previousState = State.GRAB;
            return;
        }
        this.stateRunAroundItems();
    }

    private void stateEngage() {
        this.user.info("Decision is: ENGAGE");
        this.config.setName("Hunter [ENGAGE]");
        boolean shooting = false;
        double distance = Double.MAX_VALUE;
        if (this.previousState != State.ENGAGE || this.enemy == null || !this.enemy.isVisible()) {
            this.enemy = this.players.getNearestVisiblePlayer(this.players.getVisibleEnemies().values());
            if (this.info.isShooting().booleanValue()) {
                this.getAct().act(new StopShooting());
            }
            this.runningToPlayer = false;
        }
        if (this.weaponry.getCurrentPrimaryAmmo() == 0 && this.weaponry.hasLoadedWeapon()) {
            this.user.info("No ammo - switching weapon");
            Weapon weapon = this.weaponry.getLoadedWeapons().values().iterator().next();
            this.weaponry.changeWeapon(weapon);
        } else {
            Weapon currentWeapon = this.weaponry.getCurrentWeapon();
            Weapon switchWeapon = null;
            for (Weapon weapon : this.weaponry.getLoadedRangedWeapons().values()) {
                if (!(weapon.getDescriptor().getPriDamage() > currentWeapon.getDescriptor().getPriDamage())) continue;
                switchWeapon = weapon;
            }
            if (switchWeapon != null) {
                this.weaponry.changeWeapon(switchWeapon);
            }
        }
        if (this.enemy != null) {
            distance = this.info.getLocation().getDistance(this.enemy.getLocation());
            if (this.weaponry.getCurrentWeapon() != null) {
                this.user.info("Shooting at enemy!!!");
                this.getAct().act(new Shoot().setTarget(this.enemy.getId()));
                shooting = true;
            }
        }
        int decentDistance = Math.round(this.random.nextFloat() * 800.0f) + 200;
        if (!this.enemy.isVisible() || !shooting || (double)decentDistance < distance) {
            if (!this.runningToPlayer) {
                this.pathExecutor.followPath(this.pathPlanner.computePath(this.enemy));
                this.runningToPlayer = true;
            }
        } else {
            this.runningToPlayer = false;
            this.pathExecutor.stop();
            this.getAct().act(new Stop());
        }
        this.previousState = State.ENGAGE;
    }

    protected void stateHit() {
        this.user.info("Decision is: HIT");
        this.getAct().act(new Rotate().setAmount(32000));
        this.previousState = State.OTHER;
    }

    protected void statePursue() {
        this.user.info("Decision is: PURSUE");
        this.config.setName("Hunter [PURSUE]");
        if (this.previousState != State.PURSUE) {
            this.pursueCount = 0;
            this.pathExecutor.followPath(this.pathPlanner.computePath(this.enemy));
        }
        ++this.pursueCount;
        if (this.pursueCount > 30) {
            this.reset();
        } else {
            this.previousState = State.PURSUE;
        }
    }

    private void stateMedKit() {
        this.user.info("Decision is: MEDKIT");
        this.config.setName("Hunter [MEDKIT]");
        if (this.previousState != State.MEDKIT) {
            Set<Item> okHealths;
            LinkedList<Item> healths = new LinkedList<Item>();
            healths.addAll(this.items.getSpawnedItems(ItemType.HEALTH_PACK).values());
            if (healths.size() == 0) {
                healths.addAll(this.items.getSpawnedItems(ItemType.MINI_HEALTH_PACK).values());
            }
            if ((okHealths = this.tabooItems.filter(healths)).size() == 0) {
                this.user.log(Level.WARNING, "No suitable health to run for.");
                this.stateRunAroundItems();
                return;
            }
            this.item = DistanceUtils.getNearest(okHealths, this.info.getLocation());
            this.pathExecutor.followPath(this.pathPlanner.computePath(this.item));
        }
        this.previousState = State.MEDKIT;
    }

    private void stateSeeItem() {
        this.user.info("Decision is: SEE ITEM");
        this.config.setName("Hunter [SEE ITEM]");
        if (this.item != null && this.item.getLocation().getDistance(this.info.getLocation()) < 100.0) {
            this.reset();
        }
        if (this.previousState != State.GRAB) {
            this.item = DistanceUtils.getNearest(this.items.getVisibleItems().values(), this.info.getLocation());
            if (this.item.getLocation().getDistance(this.info.getLocation()) < 300.0) {
                this.getAct().act(new Move().setFirstLocation(this.item.getLocation()));
            } else {
                this.pathExecutor.followPath(this.pathPlanner.computePath(this.item));
            }
        }
    }

    private boolean canRunAlongMedKit() {
        boolean result = !this.items.getSpawnedItems(ItemType.HEALTH_PACK).isEmpty() || !this.items.getSpawnedItems(ItemType.MINI_HEALTH_PACK).isEmpty();
        return result;
    }

    private void stateRunAroundItems() {
        this.user.info("Decision is: ITEMS");
        this.config.setName("Hunter [ITEMS]");
        if (this.previousState != State.ITEMS) {
            this.itemsToRunAround = new LinkedList<Item>(this.items.getSpawnedItems().values());
            Set<Item> items = this.tabooItems.filter(this.itemsToRunAround);
            if (items.size() == 0) {
                this.user.log(Level.WARNING, "No item to run for...");
                this.reset();
                return;
            }
            this.item = items.iterator().next();
            this.pathExecutor.followPath(this.pathPlanner.computePath(this.item));
        }
        this.previousState = State.ITEMS;
    }

    @Override
    public void botKilled(BotKilled event) {
        this.itemsToRunAround = null;
        this.enemy = null;
    }

    public static void main(String[] args) throws PogamutException {
        new MultipleUT2004BotRunner(3, Hunter.class, "Hunter").startAgent();
    }

    private static enum State {
        OTHER,
        ENGAGE,
        PURSUE,
        MEDKIT,
        GRAB,
        ITEMS;

    }
}

