/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.translator.testplan.MyUnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.WorldViewTestContext;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.WorldViewTestPlanContainer;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.converter.EventWrapperConverter;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.converter.EventWrapperWithCallCountConverter;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.converter.InputEventWrapperConverter;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.converter.ObjectClassEventWrapperConverter;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.converter.ObjectInstanceEventWrapperConverter;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.EventWrapper;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.EventWrapperWithCallCount;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.InputEventWrapper;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.ObjectClassEventWrapper;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.ObjectInstanceEventWrapper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import junit.framework.Assert;

public class TestPlanLoader {
    public static XStream createXStream(WorldViewTestContext ctx) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.aliasPackage("ut2004messages", "cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages");
        xstream.aliasPackage("basemessages", "cz.cuni.amis.pogamut.base.communication.worldview.object.event");
        xstream.aliasPackage("base3dmessages", "cz.cuni.amis.pogamut.base3d.worldview.object.event");
        xstream.alias("Id", UnrealId.class, MyUnrealId.class);
        xstream.alias("botId", UnrealId.class, MyUnrealId.class);
        xstream.alias("holder", UnrealId.class, MyUnrealId.class);
        xstream.registerConverter((Converter)new InputEventWrapperConverter(ctx));
        xstream.registerConverter((Converter)new EventWrapperConverter(ctx));
        xstream.registerConverter((Converter)new ObjectClassEventWrapperConverter(ctx));
        xstream.registerConverter((Converter)new ObjectInstanceEventWrapperConverter(ctx));
        xstream.registerConverter((Converter)new EventWrapperWithCallCountConverter(ctx));
        xstream.processAnnotations(MyUnrealId.class);
        xstream.processAnnotations(EventWrapperWithCallCount.class);
        xstream.processAnnotations(EventWrapper.class);
        xstream.processAnnotations(ObjectClassEventWrapper.class);
        xstream.processAnnotations(ObjectInstanceEventWrapper.class);
        xstream.processAnnotations(WorldViewTestPlanContainer.class);
        return xstream;
    }

    public static WorldViewTestPlanContainer loadPlan(WorldViewTestContext ctx, Reader planReader) {
        XStream xstream = TestPlanLoader.createXStream(ctx);
        return (WorldViewTestPlanContainer)xstream.fromXML(planReader);
    }

    protected void serializeTest(WorldViewTestContext ctx, LinkedList<IWorldChangeEvent> inputEvents, LinkedList<IWorldEvent> expectedEvents, LinkedList<EventWrapper> eventWrappers, LinkedList<EventWrapperWithCallCount> plan, LinkedList<InputEventWrapper> inputEventsPlan, String planFileName) {
        Assert.assertTrue((String)"planFileName has to contain the name of the plan to execute.", (planFileName != null && !planFileName.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Input messages list cannot be null or empty.", (inputEvents != null && !inputEvents.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected messages list cannot be null or empty.", (expectedEvents != null && !expectedEvents.isEmpty() ? 1 : 0) != 0);
        XStream xstream = TestPlanLoader.createXStream(ctx);
        try {
            File dir = new File("testplans/worldview/" + planFileName.substring(0, planFileName.indexOf(47)));
            if (!dir.exists() && !dir.createNewFile()) {
                Assert.fail((String)("Could not create a directory for this class test: " + dir.getName()));
            }
            FileWriter writer = new FileWriter("testplans/worldview/" + planFileName);
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            WorldViewTestPlanContainer container = new WorldViewTestPlanContainer();
            container.assignInputEvents(inputEvents);
            container.assignExpectedEvents(expectedEvents);
            container.assignEventWrappers(eventWrappers);
            container.assignInputEventsPlan(inputEventsPlan);
            container.assignExpectedEventsPlan(plan);
            writer.write(xstream.toXML((Object)container));
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to write plan file: " + planFileName));
        }
    }
}

