/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.bot.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.PathEventType;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorListener;
import cz.cuni.amis.pogamut.base.agent.navigation.PathPlanner;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UTPathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallPathPlanner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetectors.StupidStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.navigation.UT2004BotLogicTestController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.WeaponDescriptor;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotModule;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Timer;

@AgentScoped
public class RunAroundBotTestController
extends UT2004BotLogicTestController {
    protected UTPathExecutor pathExecutor = null;
    protected boolean first = true;
    private List<Item> weapons;
    private Iterator<Item> iterator;
    private int pathCount = 0;
    private boolean ready = true;
    private boolean executing;
    private Timer timer;
    private ActionListener listener;
    private PathPlanner<ILocated, ILocated> pathPlanner;
    private Location location;

    @Override
    public void botInitialized(GameInfo gameInfo, ConfigChange config, InitedMessage init) {
        this.prepareWeapons();
        this.prepareTimer();
        this.bot.getLogger().setLevel(Level.WARNING);
    }

    @Override
    public Initialize getInitializeCommand() {
        return new Initialize().setName("NavigationBot");
    }

    @Override
    public void logic() throws PogamutException {
        if (this.first) {
            this.pathPlanner = new FloydWarshallPathPlanner(this.bot);
            this.pathExecutor = new UTPathExecutor(this.bot);
            this.pathExecutor.addStuckDetector(new StupidStuckDetector(this.getWorldView(), 3.1));
            this.pathExecutor.addPathListener(new PathExecutorListener(){

                @Override
                public void onEvent(PathEventType eventType) {
                    if (eventType.equals((Object)PathEventType.TARGET_REACHED)) {
                        RunAroundBotTestController.this.processTargetReached();
                    }
                    if (eventType.equals((Object)PathEventType.PATH_BROKEN) || eventType.equals((Object)PathEventType.FAILURE) || eventType.equals((Object)PathEventType.TARGET_UNREACHABLE) || eventType.equals((Object)PathEventType.BOT_STUCKED)) {
                        RunAroundBotTestController.this.goToAnotherGoal();
                    }
                }
            });
            this.goToAnotherGoal();
            this.first = false;
        }
    }

    protected void processTargetReached() {
        this.log("----- TARGET REACHED -----");
        if (this.getAgentLocation().getDistance(this.location) < 100.0) {
            this.pathCount = 0;
            this.goToAnotherGoal();
            this.executing = true;
        } else {
            this.runToTheTarget();
        }
    }

    private Location getAgentLocation() {
        return this.getWorldView().getSingle(Self.class).getLocation();
    }

    protected void processPathProblem(PathEventType eventType) {
        this.executing = false;
        if (this.ready) {
            this.log("------------------ PATH BROKEN -------------------- " + eventType.name());
            ++this.pathCount;
            if (this.pathCount > 10) {
                this.pathCount = 0;
                this.getAct().act(new Respawn().setStartLocation(this.getNextItem().getLocation()));
            }
            this.ready = false;
            this.goToAnotherGoal();
        } else {
            this.log("------------------ PATH BROKEN -------------------- and restart " + eventType.name());
            this.timer.restart();
        }
    }

    protected void runToTheTarget() {
        this.pathExecutor.followPath(this.pathPlanner.computePath(this.location));
    }

    protected void goToAnotherGoal() {
        this.location = this.getNextItem().getLocation();
        this.log("running to location: " + this.location);
        this.runToTheTarget();
    }

    protected void prepareWeapons() {
        this.weapons = new ArrayList<Item>(20);
        for (Item item : this.getWorldView().getAll(Item.class).values()) {
            if (!(item.getDescriptor() instanceof WeaponDescriptor)) continue;
            this.weapons.add(item);
        }
        if (this.weapons.isEmpty()) {
            System.err.println("Weapons can't be empty!!! Unable to proceed!");
            this.bot.kill();
        }
        this.iterator = this.weapons.iterator();
    }

    private Item getNextItem() {
        if (!this.iterator.hasNext()) {
            Collections.shuffle(this.weapons);
            this.iterator = this.weapons.iterator();
        }
        return this.iterator.next();
    }

    @Override
    public void botKilled(BotKilled event) {
        this.timer.stop();
    }

    public static void main(String[] args) throws PogamutException {
        UT2004BotFactory factory = new UT2004BotFactory(new UT2004BotModule(RunAroundBotTestController.class));
        UT2004BotRunner botRunner = new UT2004BotRunner(factory);
        botRunner.startAgent();
    }

    private void log(String string) {
        this.bot.getLogger().getCategories().values().iterator().next().info(string);
        System.err.println(string);
    }

    private void prepareTimer() {
        this.listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunAroundBotTestController.this.ready = true;
                RunAroundBotTestController.this.timer.stop();
                if (!RunAroundBotTestController.this.executing) {
                    RunAroundBotTestController.this.goToAnotherGoal();
                }
            }
        };
        this.timer = new Timer(3000, this.listener);
    }
}

