/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.bot.navigation;

import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.ut2004.bot.navigation.UT2004BotLogicTestController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.AddInventory;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.ChangeWeapon;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Shoot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.TurnTo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotModule;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;

@AgentScoped
public class ProjectileAvoidanceTestShooter
extends UT2004BotLogicTestController {
    protected static final String SHOOTER_START = "DM-DE-Grendelkeep.PathNode90";
    protected NavPoint shooterStart;
    boolean first = true;
    int logicCounter = 0;
    protected IWorldObjectEventListener<Player, WorldObjectUpdatedEvent<Player>> playerListener;
    private Player currentTarget;
    private int changeCounter = 0;

    public ProjectileAvoidanceTestShooter() {
        super(Level.WARNING);
    }

    @Override
    public void botInitialized(GameInfo gameInfo, ConfigChange config, InitedMessage init) {
        for (WorldObjectId id : this.getWorldView().getAll(NavPoint.class).keySet()) {
            if (!id.getStringId().equals(SHOOTER_START)) continue;
            this.shooterStart = (NavPoint)this.getWorldView().get(id);
        }
        for (Item item : this.getWorldView().getAll(Item.class).values()) {
            System.out.println(String.valueOf(item.getId().getStringId()) + "\n" + item.toString());
        }
        System.err.println("BEGIN LOCATION: " + this.shooterStart.getLocation().toString());
        this.playerListener = new IWorldObjectEventListener<Player, WorldObjectUpdatedEvent<Player>>(){

            @Override
            public void notify(WorldObjectUpdatedEvent<Player> event) {
                ProjectileAvoidanceTestShooter.this.targetAcquired((Player)event.getObject());
            }
        };
        this.getWorldView().addObjectListener(Player.class, WorldObjectUpdatedEvent.class, this.playerListener);
    }

    protected void targetAcquired(Player object) {
        if (!object.equals(this.currentTarget)) {
            this.currentTarget = object;
        }
        ++this.changeCounter;
        if (this.logicCounter % 3 == 1) {
            this.getAct().act(new Shoot().setLocation(this.currentTarget.getLocation()));
        }
        if (this.currentTarget != null && this.currentTarget.getLocation() != null) {
            if (this.changeCounter % 7 == 1) {
                this.getAct().act(new Shoot().setLocation(this.currentTarget.getLocation()));
            }
            if (this.changeCounter % 5 == 4) {
                this.getAct().act(new TurnTo().setLocation(this.currentTarget.getLocation()));
            }
        }
    }

    @Override
    public Initialize getInitializeCommand() {
        this.setLatch(new CountDownLatch(3));
        return new Initialize().setName("ProjectileAvoidanceShooter").setLocation(this.shooterStart.getLocation());
    }

    @Override
    public void logic() throws PogamutException {
        if (this.first) {
            this.equipShooter();
            this.first = false;
        }
        if (this.logicCounter % 22 == 0) {
            this.getAct().act(new ChangeWeapon().setId("Best"));
        }
        if (this.logicCounter % 100 == 0) {
            this.getAct().act(new AddInventory().setType("XWeapons.RocketAmmoPickup"));
        }
        ++this.logicCounter;
    }

    private void equipShooter() {
        this.getAct().act(new AddInventory().setType("XWeapons.RocketLauncherPickup"));
        this.getAct().act(new AddInventory().setType("XWeapons.RocketAmmoPickup"));
    }

    public static void main(String[] args) throws PogamutException {
        UT2004BotFactory factory = new UT2004BotFactory(new UT2004BotModule(ProjectileAvoidanceTestShooter.class));
        UT2004BotRunner botRunner = new UT2004BotRunner(factory);
        botRunner.startAgent();
    }
}

