/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.bot.impl.test;

import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateFailed;
import cz.cuni.amis.pogamut.base.communication.command.react.CommandReact;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectFuture;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.test.AbstractBotTest;
import cz.cuni.amis.pogamut.ut2004.bot.impl.test.BotTestLogic;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.TurnTo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class SimpleBotTest
extends AbstractBotTest {
    private long interleave;

    public SimpleBotTest() {
        this.interleave = 0L;
    }

    public SimpleBotTest(long interleaveMillis) {
        this.interleave = interleaveMillis;
    }

    @Override
    protected void doTest(UT2004Bot bot, Logger log) {
        BotTestLogic botLogic;
        final CountDownLatch commandSentLatch = new CountDownLatch(1);
        CommandReact<TurnTo> turnToReactionOnce = new CommandReact<TurnTo>(TurnTo.class, bot.getAct()){

            @Override
            protected void react(TurnTo event) {
                commandSentLatch.countDown();
            }
        };
        bot.start();
        WorldObjectFuture<Self> self = new WorldObjectFuture<Self>(bot.getWorldView(), Self.class);
        if (self.get(10000L, TimeUnit.MILLISECONDS) == null) {
            bot.kill();
            throw new RuntimeException("Self not present in the WorldView after 10 secs.");
        }
        if (bot.getController() instanceof BotTestLogic && !(botLogic = (BotTestLogic)bot.getController()).getLatch().await(1000L, TimeUnit.MILLISECONDS)) {
            bot.kill();
            throw new RuntimeException("Self not received by LogicModule after 11 secs, even though Self received by the bot!");
        }
        bot.getAct().act(new TurnTo().setRotation(new Rotation(2000.0, 2000.0, 2000.0)));
        try {
            if (!commandSentLatch.await(1000L, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Rotation command not sensed.");
            }
        }
        catch (InterruptedException e) {
            throw new PogamutInterruptedException(e, (Object)this);
        }
        bot.stop();
        if (bot.getState().getFlag() instanceof IAgentStateFailed) {
            throw new RuntimeException("Bot failed due to previous exceptions.");
        }
        if (this.interleave > 0L) {
            log.warning("Going to sleep for " + this.interleave + " ms...");
            try {
                Thread.sleep(this.interleave);
            }
            catch (InterruptedException e) {
                throw new PogamutInterruptedException(e, (Object)this);
            }
        }
    }
}

