/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.bot.impl;

import com.google.inject.Inject;
import cz.cuni.amis.introspection.Folder;
import cz.cuni.amis.introspection.java.ReflectionObjectFolder;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.jmx.AgentJMXComponents;
import cz.cuni.amis.pogamut.base.agent.jmx.adapter.AgentMBeanAdapter;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReact;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.event.BusAwareCountDownLatch;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStartException;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.agent.AbstractAgent3D;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004Agent;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004BotController;
import cz.cuni.amis.pogamut.ut2004.bot.jmx.BotJMXMBeanAdapter;
import cz.cuni.amis.pogamut.ut2004.bot.state.impl.BotStateHelloBotReceived;
import cz.cuni.amis.pogamut.ut2004.bot.state.impl.BotStateInited;
import cz.cuni.amis.pogamut.ut2004.bot.state.impl.BotStatePassword;
import cz.cuni.amis.pogamut.ut2004.bot.state.impl.BotStateSendingInit;
import cz.cuni.amis.pogamut.ut2004.bot.state.impl.BotStateSpawned;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.PasswordReply;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Ready;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.HelloBotHandshake;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Password;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.InitCommandRequest;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.ReadyCommandRequest;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutJMXException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

@AgentScoped
public class UT2004Bot<WORLD_VIEW extends IVisionWorldView, ACT extends IAct, CONTROLLER extends IUT2004BotController>
extends AbstractAgent3D<WORLD_VIEW, ACT>
implements IUT2004Agent {
    private CONTROLLER controller;
    private BusAwareCountDownLatch endMessageLatch;
    private boolean botStoppedCalled = false;
    private EventReact<HelloBotHandshake> helloBotReaction;
    private IWorldEventListener<ReadyCommandRequest> readyCommandRequestListener = new IWorldEventListener<ReadyCommandRequest>(){

        @Override
        public void notify(ReadyCommandRequest event) {
            UT2004Bot.this.setState(new BotStateHelloBotReceived("GameBots2004 greeted us, adding custom listeners onto the worldview."));
            UT2004Bot.this.readyCommandRequested();
            UT2004Bot.this.setState(new BotStateHelloBotReceived("READY sent, handshaking."));
        }
    };
    private IWorldEventListener<InitCommandRequest> initCommandRequestListener = new IWorldEventListener<InitCommandRequest>(){

        @Override
        public void notify(InitCommandRequest event) {
            UT2004Bot.this.setState(new BotStateSendingInit("Handshake over, sending INIT."));
            UT2004Bot.this.initCommandRequested();
            UT2004Bot.this.setState(new BotStateSendingInit("Handshake over, INIT sent."));
        }
    };
    private IWorldEventListener<Password> passwordRequestedListener = new IWorldEventListener<Password>(){

        @Override
        public void notify(Password event) {
            UT2004Bot.this.setState(new BotStatePassword("Password requested by the world."));
            PasswordReply passwordReply = UT2004Bot.this.getController().getPassword();
            if (passwordReply == null) {
                UT2004Bot.this.log.warning("createPasswordReply() returned null");
                passwordReply = new PasswordReply("");
            }
            UT2004Bot.this.log.info("Password required for the world, replying with '" + passwordReply.getPassword() + "'.");
            UT2004Bot.this.getAct().act(passwordReply);
            UT2004Bot.this.setState(new BotStatePassword("Password sent."));
        }
    };
    private IWorldObjectEventListener<InitedMessage, WorldObjectUpdatedEvent<InitedMessage>> initedMessageListener = new IWorldObjectEventListener<InitedMessage, WorldObjectUpdatedEvent<InitedMessage>>(){

        @Override
        public void notify(WorldObjectUpdatedEvent<InitedMessage> event) {
            UT2004Bot.this.setState(new BotStateInited("InitedMessage received, calling botInitialized()."));
            UT2004Bot.this.controller.botInitialized(UT2004Bot.this.getWorldView().getSingle(GameInfo.class), UT2004Bot.this.getWorldView().getSingle(ConfigChange.class), (InitedMessage)event.getObject());
            UT2004Bot.this.setState(new BotStateInited("Bot initialized."));
        }
    };
    private IWorldEventListener<BotKilled> killedListener = new IWorldEventListener<BotKilled>(){

        @Override
        public void notify(BotKilled event) {
            UT2004Bot.this.getController().botKilled(event);
        }
    };
    private IWorldEventListener<EndMessage> endListener = new IWorldEventListener<EndMessage>(){

        @Override
        public void notify(EndMessage event) {
            UT2004Bot.this.setState(new BotStateSpawned("First batch of informations received - calling botSpawned()."));
            UT2004Bot.this.controller.botSpawned(UT2004Bot.this.getWorldView().getSingle(GameInfo.class), UT2004Bot.this.getWorldView().getSingle(ConfigChange.class), UT2004Bot.this.getWorldView().getSingle(InitedMessage.class), UT2004Bot.this.getWorldView().getSingle(Self.class));
            UT2004Bot.this.setState(new BotStateSpawned("botSpawned() finished, UT2004Bot is running."));
            UT2004Bot.this.getWorldView().removeEventListener(EndMessage.class, this);
            UT2004Bot.this.endMessageLatch.countDown();
        }
    };

    @Inject
    public UT2004Bot(IAgentId agentId, IComponentBus eventBus, IAgentLogger logger, IWorldView worldView, IAct act, IUT2004BotController init) {
        super(agentId, eventBus, logger, (IVisionWorldView)worldView, act);
        this.controller = init;
        NullCheck.check(this.controller, "init");
        this.log.finer("Initializing the controller...");
        this.controller.initializeController((UT2004Bot)this);
        this.log.finer("Preparing the controller...");
        this.controller.prepareBot((UT2004Bot)this);
        this.log.fine("Controller initialized.");
        this.helloBotReaction = new EventReact<HelloBotHandshake>(HelloBotHandshake.class, worldView){

            @Override
            protected void react(HelloBotHandshake event) {
                if (event.isServerFull()) {
                    throw new ComponentCantStartException("Server is full.", UT2004Bot.this);
                }
            }
        };
        this.getWorldView().addEventListener(ReadyCommandRequest.class, this.readyCommandRequestListener);
        this.getWorldView().addEventListener(InitCommandRequest.class, this.initCommandRequestListener);
        this.getWorldView().addEventListener(Password.class, this.passwordRequestedListener);
        this.getWorldView().addObjectListener(InitedMessage.class, WorldObjectUpdatedEvent.class, this.initedMessageListener);
        this.getWorldView().addEventListener(BotKilled.class, this.killedListener);
        this.endMessageLatch = new BusAwareCountDownLatch(1, this.getEventBus(), this.getWorldView());
    }

    public CONTROLLER getController() {
        return this.controller;
    }

    @Override
    protected void startAgent() {
        this.botStoppedCalled = false;
        super.startAgent();
        this.getWorldView().addEventListener(EndMessage.class, this.endListener);
        this.log.info("Waiting for the handshake to finish for 60s.");
        if (!this.endMessageLatch.await(60000L, TimeUnit.MILLISECONDS)) {
            throw new ComponentCantStartException("The bot did not received first EndMessage in 60 seconds.", this);
        }
        this.log.info("Handshake finished.");
    }

    @Override
    protected void stopAgent() {
        try {
            if (!this.botStoppedCalled) {
                this.botStoppedCalled = true;
                this.controller.botShutdown();
            }
        }
        finally {
            super.stopAgent();
        }
        this.endMessageLatch = new BusAwareCountDownLatch(1, this.getEventBus(), this.getWorldView());
    }

    @Override
    protected void killAgent() {
        try {
            if (!this.botStoppedCalled) {
                this.botStoppedCalled = true;
                this.controller.botShutdown();
            }
        }
        finally {
            super.killAgent();
        }
        this.endMessageLatch = new BusAwareCountDownLatch(1, this.getEventBus(), this.getWorldView());
    }

    protected void readyCommandRequested() {
        this.getAct().act(new Ready());
    }

    protected void initCommandRequested() {
        Initialize initializeCommand = this.getController().getInitializeCommand();
        if (initializeCommand == null) {
            throw new AgentException("getBotInit().getInitializeCommand() method returned null message, can't initialize the agent!", (Logger)this.log, (Object)this);
        }
        if (initializeCommand.getName() == null) {
            initializeCommand.setName(this.getComponentId().getName().getFlag());
        } else {
            this.getComponentId().getName().setFlag(initializeCommand.getName());
        }
        try {
            initializeCommand.setJmx(this.getJMX().enableJMX());
        }
        catch (Exception e) {
            throw new PogamutJMXException("Error seting up JMX name of the agent.", (Throwable)e, this.log, this);
        }
        this.getAct().act(initializeCommand);
    }

    @Override
    public Location getLocation() {
        Self self = this.getWorldView().getSingle(Self.class);
        if (self != null) {
            return self.getLocation();
        }
        return null;
    }

    @Override
    public Rotation getRotation() {
        Self self = this.getWorldView().getSingle(Self.class);
        if (self != null) {
            return self.getRotation();
        }
        return null;
    }

    @Override
    public Velocity getVelocity() {
        Self self = this.getWorldView().getSingle(Self.class);
        if (self != null) {
            return self.getVelocity();
        }
        return null;
    }

    @Override
    public void respawn() throws PogamutException {
        this.getAct().act(new Respawn());
    }

    @Override
    protected AgentJMXComponents createAgentJMX() {
        return new AgentJMXComponents<IUT2004Agent>((IUT2004Agent)this){

            @Override
            protected AgentMBeanAdapter createAgentMBean(ObjectName objectName, MBeanServer mbs) throws MalformedObjectNameException, InstanceAlreadyExistsException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
                return new BotJMXMBeanAdapter<UT2004Bot>(UT2004Bot.this, objectName, mbs);
            }
        };
    }

    @Override
    public void setBoolConfigure(IUT2004Agent.BoolBotParam param, boolean value) {
        try {
            Configuration configuration = new Configuration();
            ConfigChange confCh = this.getWorldView().getSingle(ConfigChange.class);
            configuration.copy(confCh);
            param.set(configuration, value);
            param.setField(confCh, value);
            this.getAct().act(configuration);
        }
        catch (Exception ex) {
            Logger.getLogger(UT2004Bot.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public boolean getBoolConfigure(IUT2004Agent.BoolBotParam param) {
        try {
            return param.get(this.getWorldView().getSingle(ConfigChange.class));
        }
        catch (Exception ex) {
            Logger.getLogger(UT2004Bot.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @Override
    protected Folder createIntrospection() {
        return new ReflectionObjectFolder("root", this.controller);
    }

    @Override
    public WORLD_VIEW getWorldView() {
        return (WORLD_VIEW)((IVisionWorldView)super.getWorldView());
    }
}

