/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.bot.impl;

import cz.cuni.amis.introspection.Folder;
import cz.cuni.amis.introspection.IntrospectionException;
import cz.cuni.amis.introspection.Property;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.exceptions.CantStartJMXException;
import cz.cuni.amis.pogamut.base.agent.exceptions.JMXAlreadyEnabledException;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentStateStarted;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.ILogCategories;
import cz.cuni.amis.pogamut.base.utils.logging.ILogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004Agent;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Kick;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class NativeUT2004BotAdapter
implements IUT2004Agent {
    private IAgentLogger logger = new IAgentLogger(){
        private LogCategory single = new LogCategory("default");
        private ILogCategories categories = new ILogCategories(){

            @Override
            public boolean hasCategory(String name) {
                if (name == null) {
                    return false;
                }
                return name.equalsIgnoreCase("default");
            }

            @Override
            public Map<String, LogCategory> getCategories() {
                HashMap<String, LogCategory> categories = new HashMap<String, LogCategory>();
                categories.put("default", single);
                return Collections.unmodifiableMap(categories);
            }

            @Override
            public String[] getCategoryNames() {
                return new String[]{"default"};
            }

            @Override
            public String[] getCategoryNamesSorted() {
                return new String[]{"default"};
            }

            @Override
            public LogCategory getCategory(String name) {
                if (name == null) {
                    throw new UnsupportedOperationException("Not supported for the native bot.");
                }
                if (name.equals("default")) {
                    return single;
                }
                throw new UnsupportedOperationException("Not supported for the native bot.");
            }

            @Override
            public void setLevel(Level newLevel) {
                single.setLevel(newLevel);
            }

            @Override
            public void addLogCategory(String name, LogCategory category) {
                throw new UnsupportedOperationException("Not supported for the native bot.");
            }
        };

        @Override
        public void addDefaultConsoleHandler() {
            throw new UnsupportedOperationException("Not supported for the native bot.");
        }

        @Override
        public void addDefaultFileHandler(File file) {
            throw new UnsupportedOperationException("Not supported for the native bot.");
        }

        @Override
        public void addDefaultHandler(Handler handler) {
            throw new UnsupportedOperationException("Not supported for the native bot.");
        }

        @Override
        public void addDefaultPublisher(ILogPublisher publisher) {
            throw new UnsupportedOperationException("Not supported for the native bot.");
        }

        @Override
        public void addToAllCategories(ILogPublisher logPublisher) {
            this.single.addHandler(logPublisher);
        }

        @Override
        public void addToAllCategories(Handler handler) {
            this.single.addHandler(handler);
        }

        @Override
        public IAgentId getAgentId() {
            return NativeUT2004BotAdapter.this.agentId;
        }

        @Override
        public Map<String, LogCategory> getCategories() {
            return this.categories.getCategories();
        }

        @Override
        public LogCategory getCategory(IComponent component) {
            return this.categories.getCategory(component.getComponentId().getToken());
        }

        @Override
        public LogCategory getCategory(String name) {
            return this.categories.getCategory(name);
        }

        @Override
        public void setLevel(Level newLevel) {
            this.categories.setLevel(newLevel);
        }

        @Override
        public void enableJMX(MBeanServer mBeanServer, ObjectName parent) throws JMXAlreadyEnabledException, CantStartJMXException {
            throw new UnsupportedOperationException("Not supported for the native bot.");
        }
    };
    protected Player player = null;
    protected IUT2004Server server = null;
    protected IAct act;
    protected IWorldView worldView = null;
    protected ConfigChange config = null;
    private Flag<IAgentState> state = new Flag<AgentStateStarted>(new AgentStateStarted("Native bot is running."));
    private IAgentId agentId;
    private Folder folder = new Folder("empty"){
        private Folder[] subfolders;
        private Property[] properties;
        {
            this.subfolders = new Folder[0];
            this.properties = new Property[0];
        }

        public Folder[] getFolders() throws IntrospectionException {
            return this.subfolders;
        }

        public Property[] getProperties() throws IntrospectionException {
            return this.properties;
        }
    };

    public NativeUT2004BotAdapter(Player player, IUT2004Server server, IAct act, IWorldView worldView) {
        this.player = player;
        this.agentId = new AgentId(player.getName());
        this.server = server;
        this.act = act;
        this.worldView = worldView;
    }

    @Override
    public IAct getAct() {
        throw new UnsupportedOperationException("Native bots cannot be controled from Java.");
    }

    @Override
    public IWorldView getWorldView() {
        return this.worldView;
    }

    @Override
    public IAgentId getComponentId() {
        return this.agentId;
    }

    @Override
    public String getName() {
        return this.agentId.getName().getFlag();
    }

    @Override
    public IAgentLogger getLogger() {
        return this.logger;
    }

    @Override
    public IComponentBus getEventBus() {
        throw new UnsupportedOperationException("Not supported for the native bot.");
    }

    @Override
    public ImmutableFlag<IAgentState> getState() {
        return this.state.getImmutable();
    }

    @Override
    public void start() throws AgentException {
        throw new UnsupportedOperationException("Native bot is already started.");
    }

    @Override
    public void pause() throws AgentException {
        throw new UnsupportedOperationException("Not supported for the native bot.");
    }

    @Override
    public void resume() throws AgentException {
        throw new UnsupportedOperationException("Not supported for the native bot.");
    }

    @Override
    public void stop() {
        this.act.act(new Kick(this.player.getId()));
    }

    @Override
    public void kill() {
        this.stop();
    }

    @Override
    public Folder getIntrospection() {
        return this.folder;
    }

    @Override
    public Location getLocation() {
        return this.player.getLocation();
    }

    @Override
    public Velocity getVelocity() {
        return this.player.getVelocity();
    }

    @Override
    public Rotation getRotation() {
        return this.player.getRotation();
    }

    @Override
    public void respawn() throws PogamutException {
        this.act.act(new Respawn(this.player.getId(), null, null));
    }

    @Override
    public void setBoolConfigure(IUT2004Agent.BoolBotParam param, boolean value) {
        try {
            Configuration configuration = new Configuration();
            configuration.setId(this.player.getId());
            ConfigChange confCh = this.getConfig();
            if (confCh != null) {
                configuration.copy(confCh);
                param.setField(confCh, value);
            }
            param.set(configuration, value);
            this.act.act(configuration);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean getBoolConfigure(IUT2004Agent.BoolBotParam param) {
        try {
            ConfigChange confCh = this.getConfig();
            if (confCh != null) {
                return param.get(this.getConfig());
            }
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    protected ConfigChange getConfig() {
        if (this.config == null) {
            for (ConfigChange c : this.worldView.getAll(ConfigChange.class).values()) {
                if (!c.getBotId().equals(this.player.getId())) continue;
                this.config = c;
                break;
            }
        }
        return this.config;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof NativeUT2004BotAdapter)) {
            return false;
        }
        NativeUT2004BotAdapter otherAdapter = (NativeUT2004BotAdapter)other;
        return this.agentId.equals(otherAdapter.getComponentId());
    }

    public int hashCode() {
        return this.agentId.hashCode();
    }
}

