/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetectors;

import cz.cuni.amis.pogamut.base.agent.navigation.PathEventType;
import cz.cuni.amis.pogamut.base.agent.navigation.stuckdetectors.AbstractStuckDetector;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.logging.Logger;

public class OndraStuckDetector
extends AbstractStuckDetector {
    private static final Logger log = Logger.getLogger("StupidStuckDetector");
    protected static final int BEGIN_MAX = 10;
    private int beginCount = 0;
    private boolean onMyWay = false;
    private Location lastPosition = null;
    private IWorldEventListener<BeginMessage> timeListener = new IWorldEventListener<BeginMessage>(){

        @Override
        public void notify(BeginMessage event) {
            if (OndraStuckDetector.this.onMyWay) {
                OndraStuckDetector ondraStuckDetector = OndraStuckDetector.this;
                ondraStuckDetector.beginCount = ondraStuckDetector.beginCount + 1;
            }
            if (OndraStuckDetector.this.beginCount > 10) {
                OndraStuckDetector.this.fireEvent(PathEventType.BOT_STUCKED);
            }
        }
    };
    private IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>> selfListener = new IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>>(){

        @Override
        public void notify(WorldObjectUpdatedEvent<Self> event) {
            Self self = (Self)event.getObject();
            if (OndraStuckDetector.this.lastPosition != null && self.getLocation().getDistance(OndraStuckDetector.this.lastPosition) > 80.0) {
                OndraStuckDetector.this.lastPosition = self.getLocation();
                OndraStuckDetector.this.beginCount = 0;
            }
        }
    };

    public OndraStuckDetector(IWorldView worldView, double detectTime) {
        worldView.addEventListener(BeginMessage.class, this.timeListener);
        worldView.addObjectListener(Self.class, WorldObjectUpdatedEvent.class, this.selfListener);
    }

    @Override
    public void followPathCallSucessfull() {
        this.onMyWay = true;
    }

    @Override
    public void onEvent(PathEventType eventType) {
        switch (eventType) {
            case TARGET_REACHED: {
                this.onMyWay = false;
                this.beginCount = 0;
                break;
            }
            case PATH_ELEMENT_REACHED: {
                this.beginCount = 0;
            }
        }
    }
}

