/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.steering.utils;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.steering.utils.UTLine2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class VectorMathUtils {
    public static Line2D getLine2D(Location loc, Velocity vel) {
        return new Line2D.Double(loc.getX(), loc.getY(), vel.getX(), vel.getY());
    }

    public static Point2D getCrossOfTrajectories(Location loc1, Velocity vel1, Location loc2, Velocity vel2) {
        return new UTLine2D(loc2, vel2).getDirectedIntersection(new UTLine2D(loc1, vel1));
    }

    public static Point2D subtract(Point2D p1, Point2D p2) {
        return new Point2D.Double(p1.getX() - p2.getX(), p1.getY() - p2.getY());
    }

    public static Point2D add(Point2D p1, Point2D p2) {
        return new Point2D.Double(p1.getX() + p2.getX(), p1.getY() + p2.getY());
    }

    public static Location pointToLocation(Point2D point, Double z) {
        return new Location(point.getX(), point.getY(), z);
    }

    public static Point2D getPoint(Location loc) {
        return new Point2D.Double(loc.x, loc.y);
    }

    public static double estimatedTimeToPosition(Point2D position, Location loc, Velocity vel) {
        Point2D.Double start = new Point2D.Double(loc.x, loc.y);
        Point2D.Double velocity = new Point2D.Double(vel.x, vel.y);
        double distance = start.distance(position);
        double speed = start.distance(velocity);
        if (speed != 0.0) {
            return distance / speed;
        }
        return Double.MAX_VALUE;
    }

    public static Point2D multiply(Point2D point, double i) {
        return new Point2D.Double(point.getX() * i, point.getY() * i);
    }
}

